% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_test.R
\name{create_test}
\alias{create_test}
\title{Create Test Function}
\usage{
create_test(
  dimension_test = NULL,
  combinations_test = NULL,
  row_duplicates = FALSE,
  col_duplicates = FALSE,
  min_threshold_test = NULL,
  max_threshold_test = NULL
)
}
\arguments{
\item{dimension_test}{A vector of two integers specifying the expected number
of rows and columns.}

\item{combinations_test}{A list with the elements `variables` (character
vector of variable names) and `expectation` (integer specifying the expected
number of unique combinations for each column).}

\item{row_duplicates}{Logical. If TRUE, checks for duplicate rows.}

\item{col_duplicates}{Logical. If TRUE, checks for duplicate columns.}

\item{min_threshold_test}{Named list of minimum threshold values for
specified columns.}

\item{max_threshold_test}{Named list of maximum threshold values for
specified columns.}
}
\value{
A function to be applied to the dataset.
}
\description{
This function creates a test function to perform various data validation
checks. The returned function can be applied to a dataset to perform the
specified tests.
}
\examples{

# get path
path <- system.file(
        "extdata",
        "fake_epi_df_togo.rds",
         package = "epiCleanr")

fake_epi_df_togo <- import(path)

# Set up unit-test function
my_tests <- create_test(
  # For checking the dimension of the data
  dimension_test = c(900, 9),
  # For expected number of combinations in data
 combinations_test = list(
   variables = c("month", "year", "district"),
   expectation = 12 * 5 * 15),
  # Check repeated cols, rows and max and min thresholds
  row_duplicates = TRUE, col_duplicates = TRUE,
  max_threshold_test = list(malaria_tests = 1000, cholera_tests = 1000),
 min_threshold_test = list(cholera_cases = 0, cholera_cases = 0)
)

result <- my_tests(fake_epi_df_togo)

}
