% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag.R
\name{scc_to_dag}
\alias{scc_to_dag}
\title{Transform SCC to DAG}
\usage{
scc_to_dag(scc, unknown = TRUE)
}
\arguments{
\item{scc}{An object of class \code{epicmodel_scc}.}

\item{unknown}{TRUE (default) or FALSE. If TRUE, unknown causes are added to the SCC model: every sufficient cause gets an additional
individual unknown component cause representing additional unknown components; an unknown sufficient cause is added to the model consisting
of a single unknown component cause and representing all unknown sufficient causes.}
}
\value{
A list of length 2 containing an object of class \code{dagitty} (named \code{dag}) and a data.frame containing the information, which label in the
DAG corresponds to which component cause (named \code{legend}).
}
\description{
Creates an object of class \code{dagitty} (\code{dagitty} package) from a SCC model, following VanderWeele and Robins (2007).
}
\examples{
# Create some SCC model
steplist_checked <- check_steplist(steplist_rain)
scc_model <- create_scc(steplist_checked)

# Transform it into a DAG
scc_to_dag(scc_model)
}
\references{
VanderWeele TJ, Robins JM (2007): Directed acyclic graphs, sufficient causes, and the properties of conditioning
on a common effect. American Journal of Epidemiology 166 (9): 1096–1104.
}
\seealso{
\itemize{
\item \code{\link[dagitty:dagitty]{dagitty::dagitty()}}
\item \code{\link[=new_scc]{SCC models}} for more information on unknown causes and SCC models in general
\item \code{\link[=plot_dag]{plot_dag()}} to create a \code{ggplot} object from \code{dagitty} model code
}
}
