% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIndex.R
\name{getIndex}
\alias{getIndex}
\title{Get index by specifying cut points}
\usage{
getIndex(variable, cutpoints = NULL, toLowerCategory = TRUE,
  checkOrder = FALSE)
}
\arguments{
\item{variable}{a numeric value or vector to be converted into index.}

\item{cutpoints}{a numeric vector specifying cut point values.}

\item{toLowerCategory}{a logical value specifying which to assign a cut point to lower category or upper category index. The default is assigning to lower category.}

\item{checkOrder}{a logical value specifying whether to check the order of cut points. Checking the order is skipped by default.}
}
\value{
an index vector.
}
\description{
Get index by specifying cut points. Assigns index 1 to lower than the first cut point, 2 to larger than the first cut point but lower than the second cut point, and so on. This function is intended to be used for time dependent covariate in Cox regression models to select covariate according to time point. In this case, cut points is a vector of time points, and index is used to select time-specific covariate.
}
\examples{
# cutpoint   cp(1)  cp(2)  ...   cp(n-1)  cp(n)
# index    1   *   2  *    ... (n-1) *  (n) * (n+1)
a <- rnorm(100) * 10
b <- getIndex(a, cutpoints=c(-2,-1,0,1,2))
}
\seealso{
\code{\link{selectByIndex}}, \code{\link{epifit}}
}

