% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probsens.irr.R
\name{probsens.irr}
\alias{probsens.irr}
\title{Probabilistic sensitivity analysis for exposure misclassification of person-time data and random error.}
\usage{
probsens.irr(
  counts,
  pt = NULL,
  reps = 1000,
  seca = list(dist = c("constant", "uniform", "triangular", "trapezoidal", "normal",
    "beta"), parms = NULL),
  seexp = NULL,
  spca = list(dist = c("constant", "uniform", "triangular", "trapezoidal", "normal",
    "beta"), parms = NULL),
  spexp = NULL,
  corr_se = NULL,
  corr_sp = NULL,
  alpha = 0.05
)
}
\arguments{
\item{counts}{A table or matrix where first row contains disease counts and
second row contains person-time at risk, and first and second columns are exposed
and unexposed observations, as:
\tabular{lll}{
\tab Exposed \tab Unexposed \cr
Cases \tab a \tab b \cr
Person-time \tab N1 \tab N0
}}

\item{pt}{A numeric vector of person-time at risk. If provided, \code{counts}
must be a numeric vector of disease counts.}

\item{reps}{Number of replications to run.}

\item{seca}{List defining the sensitivity of exposure classification among
those with the outcome. The first argument provides the probability distribution
function (uniform, triangular, trapezoidal, truncated normal, or beta) and the second
its parameters as a vector. Lower and upper bounds of the truncated normal have
to be between 0 and 1.
\enumerate{
\item constant: constant value,
\item uniform: min, max,
\item triangular: lower limit, upper limit, mode,
\item trapezoidal: min, lower mode, upper mode, max,
\item normal: lower bound, upper bound, mean, sd,
\item beta: alpha, beta.
}}

\item{seexp}{List defining the sensitivity of exposure classification among those without the outcome.}

\item{spca}{List defining the specificity of exposure classification among those with the outcome.}

\item{spexp}{List defining the specificity of exposure classification among those without the outcome.}

\item{corr_se}{Correlation between case and non-case sensitivities.}

\item{corr_sp}{Correlation between case and non-case specificities.}

\item{alpha}{Significance level.}
}
\value{
A list with elements:
\item{obs_data}{The analyzed 2 x 2 table from the observed data.}
\item{obs_measures}{A table of observed incidence rate ratio with exact confidence interval.}
\item{adj_measures}{A table of corrected incidence rate ratios.}
\item{sim_df}{Data frame of random parameters and computed values.}
}
\description{
Probabilistic sensitivity analysis to correct for exposure misclassification
when person-time data has been collected.
Non-differential misclassification is assumed when only the two bias parameters
\code{seca} and \code{spca} are provided. Adding the 2 parameters
\code{seexp} and \code{spexp} (i.e. providing the 4 bias parameters)
evaluates a differential misclassification.
}
\details{
Correlations between sensitivity (or specificity) of exposure classification
among cases and controls can be specified and use the NORmal To Anything
(NORTA) transformation (Li & Hammond, 1975).
}
\section{Updated calculations}{

episensr 2.0.0 introduced updated calculations of probabilistic bias analyses
by (1) using the NORTA transformation to define a correlation between
distributions, and (2) sampling true prevalences and then sampling the
adjusted cell counts rather than just using the expected cell counts from a
simple quantitative bias analysis. This updated version should be preferred
but if you need to run an old analysis, you can easily revert to the
computation using \code{\link[=probsens.irr_legacy]{probsens.irr_legacy()}} as follows:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(episensr)
probsens.irr <- probsens.irr_legacy
}\if{html}{\out{</div>}}
}

\examples{
set.seed(123)
# Exposure misclassification, non-differential
probsens.irr(matrix(c(2, 67232, 58, 10539000),
dimnames = list(c("GBS+", "Person-time"), c("HPV+", "HPV-")), ncol = 2),
reps = 20000,
seca = list("trapezoidal", c(.4, .45, .55, .6)),
spca = list("constant", 1))
}
\references{
Li, S.T., Hammond, J.L., 1975. \emph{Generation of Pseudorandom Numbers
with Specified Univariate Distributions and Correlation Coefficients}.
IEEE Trans Syst Man Cybern 5:557-561.
}
\seealso{
Other misclassification: 
\code{\link{misclass}()},
\code{\link{misclass_cov}()}
}
\concept{misclassification}
