% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_linelist.R
\name{sim_linelist}
\alias{sim_linelist}
\title{Simulate simple linelist data}
\usage{
sim_linelist(
  n = 1,
  onset_from = as.Date("2020-01-01"),
  onset_span = 60,
  report_delay = 7,
  cfr = 0.1
)
}
\arguments{
\item{n}{Number of entries to simulate.}

\item{onset_from}{The earliest date of symptom onset which can be generated.}

\item{onset_span}{The time span over which to generate dates of onset.}

\item{report_delay}{The mean delay between onset and reporting, using a
Poisson distribution.}

\item{cfr}{The case fatality ratio, i.e. the proportion of patient dying from
the infection (used to generate the 'outcome' variable).}
}
\description{
This function simulates a simple linelist data including dates of
epidemiological events and basic patient information. No underlying
epidemiological model is used.
}
\examples{
sim_linelist(10)
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
