% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idd.R
\name{get_idd_field}
\alias{get_idd_field}
\title{Get field data}
\usage{
get_idd_field(
  idd_env,
  class,
  field = NULL,
  property = NULL,
  all = FALSE,
  underscore = TRUE,
  no_ext = FALSE,
  complete = FALSE
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{class}{An integer vector of valid class indexes or a character vector
of valid class names.}

\item{field}{An integer vector of valid field indexes or a character
vector of valid field names (can be in in underscore style).  \code{class}
and \code{field} should have the same length.}

\item{property}{A character vector of column names in field table to return.}

\item{underscore}{If \code{TRUE}, input class name and field names will be
converted into underscore style name first and column \code{class_name_us}
and \code{field_name_us} will be used for matching.}

\item{no_ext}{If \code{TRUE}, no new extensible groups will be added even if there
are no matched input found and an error will be issued right away.}

\item{complete}{If \code{TRUE}, at least fields till the current whole extensible
group will be returned. A new column named "matched_rleid" will be
created (when \code{property} is NULL) indicating if given field has been
matched or not.}
}
\value{
A data.table containing specified columns.
}
\description{
Get field data
}
\keyword{internal}
