% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeNeuroTable.R
\name{createBaseTable}
\alias{createBaseTable}
\title{Create the final resulting data frame}
\usage{
createBaseTable(neurospace, atchashda, atchashsec, dneuromaxk)
}
\arguments{
\item{neurospace}{list of drug names that were aggregated using TopKLists::calculate.max topkspace}

\item{atchashda}{hashmap retrieved from readAtcMapIntoHashMapDrugNamesAtcCodes}

\item{atchashsec}{hashmap retrieved from readSecondLevelATC}

\item{dneuromaxk}{data frame containing columns for each intersection, ATC class, and reference list}
}
\value{
data frame containing drug names with additional columns listing association to ATC classes
}
\description{
Create the final resulting data frame
}
\examples{
utils::data(rawDrugNamesCoOcEpSO, package="epos")
utils::data(rawDrugNamesCoOcESSO, package="epos")
utils::data(rawDrugNamesCoOcEPILONT, package="epos")
utils::data(rawDrugNamesCoOcEPISEM, package="epos")
utils::data(rawDrugNamesCoOcFENICS, package="epos")
atchashda <-
readAtcMapIntoHashMapDrugNamesAtcCodes(
  system.file("extdata", "db-atc.map", package = "epos"), "\t")
atchashaa <-
  readAtcMapIntoHashMapAtcCodesAtcNames(
    system.file("extdata", "db-atc.map", package = "epos"), "\t")
atchashsec <-
  readSecondLevelATC(
    system.file("extdata", "atc-secondlevel.map", package = "epos"), "\t")
epso <- genDictListFromRawFreq(rawDrugNamesCoOcEpSO)
neuroepso <- filterNeuroDrugs(epso, atchashda)
esso <- genDictListFromRawFreq(rawDrugNamesCoOcESSO)
neuroesso   <- filterNeuroDrugs(esso, atchashda)
epi <- genDictListFromRawFreq(rawDrugNamesCoOcEPILONT)
neuroepi    <- filterNeuroDrugs(epi, atchashda)
episem <- genDictListFromRawFreq(rawDrugNamesCoOcEPISEM)
neuroepisem <- filterNeuroDrugs(episem, atchashda)
fenics <- genDictListFromRawFreq(rawDrugNamesCoOcFENICS)
neurofenics <- filterNeuroDrugs(fenics, atchashda)
mx <- max(
    c(length(neuroepso), length(neuroesso), length(neuroepi),
      length(neuroepisem), length(neurofenics)))
dneuro <-
  data.frame(EpSO = c(neuroepso, rep(0, (mx-length(neuroepso)))),
             ESSO = c(neuroesso, rep(0, (mx-length(neuroesso)))),
             EPILONT = c(neuroepi, rep(0, (mx-length(neuroepi)))),
             EPISEM = c(neuroepisem, rep(0, (mx-length(neuroepisem)))),
             FENICS = c(neurofenics, rep(0, (mx-length(neurofenics)))))
dneuromaxk <- TopKLists::calculate.maxK(dneuro, 5, 5, 10)
neurospace <- as.character(dneuromaxk$topkspace)
neurotable <-
  createBaseTable(neurospace, atchashda, atchashsec, dneuromaxk)
}
