% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crtAddIntervention.R
\name{crtAddIntervention}
\alias{crtAddIntervention}
\title{Add a New Intervention Group to Clustered Randomized Trial (CRT)}
\usage{
crtAddIntervention(
  originalData,
  ns,
  np,
  es,
  attritionrate,
  outcome,
  interventions,
  schoolsID,
  pupilsID,
  covariates
)
}
\arguments{
\item{originalData}{A data frame containing the variables including outcome, predictors, the clustering variable, and the intervention for CRT design.}

\item{ns}{The number of schools to assign to the new intervention group.}

\item{np}{The number of pupils per new school.}

\item{es}{The standardized effect size for the new intervention group.}

\item{attritionrate}{The proportion of pupils in the new group to drop due to attrition.}

\item{outcome}{A string specifying the name of the column containing outcome variable (e.g., post-test scores).}

\item{interventions}{A string specifying the name of the intervention assignment column.}

\item{schoolsID}{A string specifying the name of the school ID column.}

\item{pupilsID}{A string specifying the name of the pupil ID column.}

\item{covariates}{A string vector specifying the names of additional covariates (both categorical and continuous) used in the model.}
}
\value{
A \code{data.frame} combining the original and new intervention group, including post-test outcomes
simulated for the new intervention based on the estimated mixed model.
}
\description{
This function adds a new intervention group to an existing CRT dataset. It models
post-test outcomes using fixed and random effects estimated from the original data and incorporates
user-specified effect size and attrition for the new intervention.
}
\details{
The function performs the following:
\itemize{
\item Fits a linear mixed-effects model (\code{lmer}) to the original dataset using provided covariates.
\item Applies the specified effect size (\code{es}) and generates new post-test scores.
\item Simulates attrition by removing post-test scores at random.
}
}
\examples{
data(crt4armSimData)
new_crt5armData <- crtAddIntervention(originalData = crt4armSimData, ns = 2, np = 100, es = 0.3, 
attritionrate = 0.1, outcome = "posttest", interventions = "interventions", schoolsID = "schools", 
pupilsID = "pupils", covariates = c("pretest"))
head(new_crt5armData)

}
\seealso{
\code{\link[lme4]{lmer}} from the \pkg{lme4} package
}
