% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_aux.R
\name{.check_uniqueness}
\alias{.check_uniqueness}
\title{Check the uniqueness of groups
This function takes a data frame `df` and a vector of columns `group_by`, and checks whether the combinations of values in the columns specified by `group_by` are unique. If the combinations are not unique, a warning message is printed.}
\usage{
.check_uniqueness(df, group_by)
}
\arguments{
\item{df}{A data frame.}

\item{group_by}{A character vector of column names in `df` that specify the groups to check for uniqueness.}
}
\value{
No return value, called for side effects: it will stop with an error if any group combinations are not unique.
}
\description{
Check the uniqueness of groups
This function takes a data frame `df` and a vector of columns `group_by`, and checks whether the combinations of values in the columns specified by `group_by` are unique. If the combinations are not unique, a warning message is printed.
}
\examples{
df <- data.frame(id = c(1, 1, 1, 1, 2, 2),
                 fu = rep(c("baseline", "follow-up"), 3),
                 value = rnorm(6))
.check_uniqueness(df, c("id", "fu"))
}
