% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQ_functions.R
\name{eq5d5l}
\alias{eq5d5l}
\title{eq5d5l}
\usage{
eq5d5l(x, country = NULL, dim.names = c("mo", "sc", "ua", "pd", "ad"))
}
\arguments{
\item{x}{A vector of 5-digit EQ-5D-5L state indexes or a matrix/data.frame with columns corresponding to EQ-5D-5L state dimensions.}

\item{country}{String vector indicating country names or  ISO3166 Alpha 2 / 3 country codes.}

\item{dim.names}{A character vector specifying the names of the EQ-5D-5L dimensions.  Default is c("mo", "sc", "ua", "pd", "ad").}
}
\value{
A vector of EQ-5D-5L values or data.frame with one column for each value set requested.
}
\description{
Get EQ-5D-5L index values from individual responses to the five dimensions of the EQ-5D-5L.
}
\examples{
eq5d5l(c(11111, 12321, 32423, 55555), 'IT') # Italy -5L value set
eq5d5l(make_all_EQ_states('5L'), c('Japan', 'China')) # Japon and China -5L value sets 
}
