% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.multinet.R
\name{Networks}
\alias{Networks}
\title{A multinetwork network representation.}
\usage{
Networks(...)
}
\arguments{
\item{...}{network specification, in one of two formats:
\enumerate{
\item An (optionally named) list of networks with same directedness and bipartedness (but possibly different sizes).
\item Several networks as (optionally named) arguments.
}}
}
\value{
A network object with multinetwork metadata.
}
\description{
A function for specifying the LHS of a multi-network
(a.k.a. multilevel) ERGM. Typically used in conjunction with the
\code{\link[=N-ergmTerm]{N()}} term operator.
}
\examples{

data(samplk)

# Method 1: list of networks
monks <- Networks(list(samplk1, samplk2))
ergm(monks ~ N(~edges))

# Method 2: networks as arguments
monks <- Networks(samplk1, samplk2)
ergm(monks ~ N(~edges))

}
\seealso{
\link[=ergmTerm]{Help on model specification} for specific terms

\code{vignette("Goeyvaerts_reproduction")} for a demonstration
}
