% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofN.R
\name{lm.gofN}
\alias{lm.gofN}
\title{Fit a linear model to the residuals in a gofN object.}
\usage{
lm.gofN(formula, data, ...)
}
\arguments{
\item{formula}{an \code{\link{lm}}-style formula. See Details for
interpretation.}

\item{data}{a \code{\link{gofN}} object.}

\item{...}{additional arguments to \code{\link[=lm]{lm()}}, excluding \code{weights}.}
}
\value{
A list of \code{\link{lm}} objects, one for each element of the
vector on the LHS.
}
\description{
This non-method runs a properly weighted linear model on the raw
residuals of a \code{\link{gofN}} simulation for a multi-network ERGM fit.
}
\details{
The \code{formula}'s RHS is evaluated in an environment
comprising the network statistics used in the \code{\link[=gofN]{gofN()}} call
(which refer to the raw residuals for the corresponding
statistic) and the network attributes.

The LHS is handled in a nonstandard manner, designed to make it
easier to reference the usually lengthy network statistics:
first, it is evaluated in the formula's environment. If the
evaluation is successful and the result is numeric, these numbers
are used as indices of the statistics in the \code{\link{gofN}} object to
use on the RHS. If it is a character vector, it is treated as
names of these statistics.
}
\examples{
data(samplk)
# Add time indices:
samplk1 \%n\% "t" <- 1
samplk2 \%n\% "t" <- 2
samplk3 \%n\% "t" <- 3

monks <- Networks(samplk1, samplk2, samplk3)

fit <- ergm(monks~N(~edges+nodematch("group")))
fit.gof <- gofN(fit) # GOF = original model

# Is there a time effect we should incorporate?
fit.gof.lm <- lm.gofN((1:2)~t, data=fit.gof)

lapply(fit.gof.lm, summary)

}
\seealso{
\code{\link[=gofN]{gofN()}} and related methods.
}
