% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pending_update_network.R
\name{pending_update_network}
\alias{pending_update_network}
\alias{is.pending_update_network}
\alias{as.edgelist.pending_update_network}
\alias{as.matrix.pending_update_network}
\alias{as.network.pending_update_network}
\alias{network.edgecount.pending_update_network}
\alias{network.dyadcount.pending_update_network}
\alias{network.size.pending_update_network}
\alias{network.naedgecount.pending_update_network}
\title{A (Relatively) Lightweight Read-Only Representation of Network Objects}
\usage{
pending_update_network(nw, update = NULL, response = if
  (is.character(update)) update)

is.pending_update_network(x)

\method{as.edgelist}{pending_update_network}(x, ...)

\method{as.matrix}{pending_update_network}(x, matrix.type = NULL,
  attrname = NULL, ...)

\method{as.network}{pending_update_network}(x, ..., populate = TRUE)

\method{network.edgecount}{pending_update_network}(x, na.omit = TRUE,
  ...)

\method{network.dyadcount}{pending_update_network}(x, na.omit = TRUE,
  ...)

\method{network.size}{pending_update_network}(x, ...)

\method{network.naedgecount}{pending_update_network}(x, ...)
}
\arguments{
\item{nw}{a \code{\link{network}} object.}

\item{update}{a character string, a list with elements named
\code{"newnwtails"}, \code{"newnwheads"}, and (optionally)
\code{"newnwweights"}, or \code{"newedgelist"}, or \code{NULL}. See Details.}

\item{response, attrname}{Name of edge attribute to get or set. If
\code{NULL}, binary network is assumed.}

\item{na.omit}{Whether missing edges should be counted. Note that
missing edge information is not stored.}
}
\value{
At this time, a \code{pending_update_network} object is (subject to
change) a \code{\link{network}} object with all edges removed and with a
network attribute \code{".update"} containing a two or three column
matrix with a (possibly valued) edge list. The third column name
also indicates the edge attribute represented.

If \code{update} uses \code{"newedgelist"}, it is copied directly; othewirse,
\code{"newnwtails"}, \code{"newnwheads"}, and (optionally) \code{"newnwweights"}
are converted to an edgelist.

Its class is set (not subclassed!) to \code{pending_update_network}, in
order to prevent \code{\link{network}} accessors and modifiers from affecting
it.
}
\description{
\code{pending_update_network} is an semi-internal class for passing
around results of MCMC sampling, particularly when the result is
used to start another MCMC sampler. It is deliberately loosely
specified, and its structure and even name are subject to change.
}
\details{
The \code{update} argument controls the contents of the object
depending on its mode: \describe{

\item{\code{NULL}}{Use \code{nw}'s own edgelist, and don't set weights.}

\item{\code{character}}{Use \code{nw}'s own edgelist, and don't set weights
for attribute specified by \code{update}.}

\item{\code{a list}}{Use the elements of the list, dropping others.}

}
}
\section{Methods (by generic)}{
\itemize{
\item \code{network.edgecount}: Note that this method fails when
\code{na.omit=FALSE}, since missing edges are not stored.

\item \code{network.dyadcount}: Note that this method fails with
its default argument, since missing edges are not stored.

\item \code{network.naedgecount}: A stub that produces an error.
}}

\keyword{internal}
