% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.curved.R
\name{is.curved}
\alias{is.curved}
\alias{is.curved.NULL}
\alias{is.curved.formula}
\alias{is.curved.ergm}
\title{Testing for curved exponential family}
\usage{
is.curved(object, ...)

\method{is.curved}{`NULL`}(object, ...)

\method{is.curved}{formula}(object, response = NULL, basis = NULL, ...)

\method{is.curved}{ergm}(object, ...)
}
\arguments{
\item{object}{An \code{\link{ergm}} object or an ERGM formula.}

\item{\dots}{Arguments passed on to lower-level functions.}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}

\item{basis}{See \code{\link[=ergm]{ergm()}}.}
}
\value{
\code{TRUE} if the object represents a
curved exponential family; \code{FALSE} otherwise.
}
\description{
These functions test whether an ERGM fit, formula, or some other
object represents a curved exponential family.

The method for \code{NULL} always returns \code{FALSE} by
convention.
}
\details{
Curvature is checked by testing if all model parameters are canonical.
}
\keyword{model}
