% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.durational.R
\name{is.durational}
\alias{is.durational}
\alias{is.durational.NULL}
\alias{is.durational.character}
\alias{is.durational.formula}
\title{Testing for durational dependent models}
\usage{
is.durational(object, ...)

\method{is.durational}{`NULL`}(object, ...)

\method{is.durational}{character}(object, ...)

\method{is.durational}{formula}(object, response = NULL, basis = NULL, ...)
}
\arguments{
\item{object}{An \code{\link{ergm}} object or an ERGM formula, or some
characters, e.g., object="all" for monitoring purpose.}

\item{\dots}{Unused at this time.}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}

\item{basis}{See \code{\link[=ergm]{ergm()}}.}
}
\value{
\code{TRUE} if the ERGM terms in the formula or model are durational
dependent ; \code{FALSE} otherwise.
}
\description{
These functions test whether an ERGM model or formula is durational
dependent or not. If the formula or model does not include any terms that
need information about the duration of existing ties, the ergm proceass can
use more efficient internal data structures.

The method for \code{NULL} always returns \code{FALSE} by
convention.

The method for \code{character} always returns \code{FALSE} by
convention.
}
\keyword{model}
