% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.inCH.R
\name{is.inCH}
\alias{is.inCH}
\alias{shrink_into_CH}
\title{Determine whether a vector is in the closure of the convex hull of some
sample of vectors}
\usage{
is.inCH(p, M, verbose = FALSE, ...)

shrink_into_CH(
  p,
  M,
  m = NULL,
  verbose = FALSE,
  ...,
  solver = c("glpk", "lpsolve")
)
}
\arguments{
\item{p}{A \eqn{d}-dimensional vector or a matrix with \eqn{d} columns}

\item{M}{An \eqn{n} by \eqn{d} matrix.  Each row of \code{M} is a
\eqn{d}-dimensional vector.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{\dots}{arguments passed directly to linear program solver}

\item{solver}{A character string selecting which solver to use; by default, tries \code{Rglpk}'s but falls back to \code{lpSolveAPI}'s.}
}
\value{
Logical, telling whether \code{p} is (or all rows of \code{p} are)
in the closed convex hull of the points in \code{M}.
}
\description{
\code{is.inCH()} returns \code{TRUE} if and only if \code{p} is contained in
the convex hull of the points given as the rows of \code{M}. If \code{p} is
a matrix, each row is tested individually, and \code{TRUE} is returned if
all rows are in the convex hull.

\code{shrink_into_CH()} returns the coefficient by which rows of \code{p} can be scaled towards or away from point \code{m} in order for all of them to be in the convex hull of \code{M} or on its boundary.
}
\details{
\code{is.inCH()} was originally written for the "stepping" algorithm of
Hummel et al (2012). See Krivitsky, Kuvelkar, and Hunter (2022) for
detailed discussion of algorithms used in \code{is.inCH()} and
\code{shrink_into_CH()}.
}
\note{
\code{\link[=is.inCH]{is.inCH()}} has been deprecated in favour of
\code{\link[=shrink_into_CH]{shrink_into_CH()}}, which returns the optimal step length instead
of a yes-or-no test. In general, \code{shrink_into_CH(...)>=1} is
equivalent to `is.inCH(...).
}
\references{
\itemize{ \item
\url{https://www.cs.mcgill.ca/~fukuda/soft/polyfaq/node22.html}

\item Hummel, R. M., Hunter, D. R., and Handcock, M. S. (2012), Improving
Simulation-Based Algorithms for Fitting ERGMs, \emph{Journal of Computational and
Graphical Statistics}, 21: 920-939.

\item Krivitsky, P. N., Kuvelkar, A. R., and Hunter,
D. R. (2022). Likelihood-based Inference for Exponential-Family
Random Graph Models via Linear Programming. \emph{arXiv preprint}
arXiv:2202.03572. \url{https://arxiv.org/abs/2202.03572}

}
}
\keyword{internal}
