% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{MaST.sim}
\alias{MaST.sim}
\title{Conduct the simulation studies of the Marker Sequential Test design}
\usage{
MaST.sim(N, rho, alpha, beta, theta, theta0, sigma0, nSim, Seed)
}
\arguments{
\item{N}{The total sample size used at the trial}

\item{rho}{The proportion of subgroup 1 among the overall patients}

\item{alpha}{The overall Type I error rate}

\item{beta}{The (1 - Power)}

\item{theta}{The sizes of treatment effect in subgroups 1 and 2 with the
experimental arm}

\item{theta0}{The size of treatment effect in the standard arm}

\item{sigma0}{The variance of the treatment effect}

\item{nSim}{The number of simulated studies}

\item{Seed}{The random seed}
}
\value{
A list contains
\itemize{
  \item nTotal The average expected sample size
  \item H00 The probability of rejecting the null hypothesis of \eqn{H_{00}}
  \item H01 The probability of rejecting the null hypothesis of \eqn{H_{01}}
  \item H02 The probability of rejecting the null hypothesis of \eqn{H_{02}}
  \item H0  The probabilities of rejecting at least one of the null hypothesis
}
}
\description{
The \code{MaST.sim()} is used to conduct the simulation studies
  of the marker sequential test design (MaST).
}
\examples{
N <- 310
rho <- 0.5
alpha <- 0.05
beta <- 0.20
theta <- c(0,0)
theta0 <- 0
sigma0 <- 1
nSim <- 1000
Seed <- 6
MaST.sim(N = N, rho = rho, alpha = alpha, beta = beta,
         theta = theta, theta0 = theta0, sigma0 = sigma0,
         nSim = nSim, Seed = Seed)
}
\references{
\itemize{
  \item Freidlin, B., Korn, E. L., and Gray, R. (2014). Marker sequential
  test (MaST) design. Clinical trials, 11(1), 19-27. <doi:10.1177/1740774513503739>
}
}
