% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{eff_at_dose}
\alias{eff_at_dose}
\title{Number of toxicities seen at each dose.}
\usage{
eff_at_dose(x, ...)
}
\arguments{
\item{x}{Object of class \code{\link{selector}}}

\item{...}{arguments passed to other methods}
}
\value{
an integer vector
}
\description{
Get the number of toxicities seen at each dose under investigation.
}
\examples{
prob_select = c(0.1, 0.3, 0.5, 0.07, 0.03)
model <- get_random_selector(prob_select = prob_select,
                             supports_efficacy = TRUE)
x <- model \%>\% fit('1NTN 2EN 5BB')
eff_at_dose(x)
}
