% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_getFDSNdata.R
\name{aux_getFDSNdata}
\alias{aux_getFDSNdata}
\title{Download seismic data from FDSN data base}
\usage{
aux_getFDSNdata(start, duration, channel = "BHZ", network, station, url,
  link_only = FALSE, eseis = TRUE)
}
\arguments{
\item{start}{\code{POSIXct} value, start time of the data to query.}

\item{duration}{\code{Numeric} value, length of the data to query, in 
seconds.}

\item{channel}{\code{Character} value, seismic channel to get. Default is
\code{"BHZ"}.}

\item{network}{\code{Character} vector, two-character FDSN network ID.}

\item{station}{\code{Character} vector, FDSN station ID.}

\item{url}{\code{Character} vector, FDSN URL.}

\item{link_only}{\code{Logical} vector, return only FDSN link instead of
downloading and importing the data.}

\item{eseis}{\code{Logical} scalar, option to read data to an \code{eseis}
object (recommended, see documentation of 
\code{aux_initiateeseis}), default is \code{TRUE}}
}
\value{
\code{List} object with imported seismic data for each provided 
set of input arguments.
}
\description{
The function accesses the specified FDSN internet data base(s) and 
downloads seismic data based on the network and station IDs and time
constraints.
}
\details{
A convenient way to get all the required input data is using the 
function \code{aux_getFDSNstation} before. It will return all the 
information in a structured way.

It is possible to use the function to process more than one data set. In 
this case, the arguments \code{network}, \code{station} and \code{url} 
must match pairwise. The arguments \code{start}, \code{duration} and 
\code{channel} will be treated as constants if not also provided as 
vectors.
}
\examples{

\dontrun{

## get stations < 0.6 degrees away from Piz Chengalo collapse
x <- aux_getFDSNstation(centre = c(46.3, 9.6),
                        radius = 0.6,
                        access = TRUE)

## sort statiions by distance
x <- x[order(x$distance),]

## download available data
d <- aux_getFDSNdata(start = as.POSIXct(x = "2017-08-23 07:30:00", 
                                        tz = "UTC"),
                     duration = 180, 
                     network = x$network_ID, 
                     station = x$station_code, 
                     url = x$network_url)

## remove stations without available data
x <- x[!unlist(lapply(d, is.null)),]
d <- d[!unlist(lapply(d, is.null))]

## generate plots of the three nearest stations
par(mfcol = c(3, 1))

for(i in 1:3) {

  plot_signal(data = d[[i]],
              main = paste(x$ID[i], 
                           " | ",
                           round(x$distance[i], 2),
                           "distance (DD)"))
} 
}
                     
}
\seealso{
aux_get_FDSNstation, read_mseed
}
\author{
Michael Dietze
}
\keyword{eseis}
