% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_checkfiles.R
\name{aux_checkfiles}
\alias{aux_checkfiles}
\title{Check structured seismic files for consistency}
\usage{
aux_checkfiles(
  dir,
  station,
  component = "BHZ",
  method = "thorough",
  period = "weekly",
  format = "sac",
  duration_set = 3600,
  plot = TRUE
)
}
\arguments{
\item{dir}{\code{Character} value, path to directorythat contains the 
seismic files to check.}

\item{station}{\code{Character} value, ID of the station of which the files 
will be checked. ID must match the IDs as used in the file names.}

\item{component}{\code{Character} value, seismic component, which must
correspond to the component name in the file name of the data directory  
structure (cf. \code{aux_organisecubefiles}). Default is 
\code{"BHZ"} (vertical component of a sac file).}

\item{method}{\code{Character} value, method used to check files. One out 
of \code{"fast"} (only file names are used to check the files, the actual 
files are not read and examined) and \code{"thorough"} (files are imported
to R and their meta data will be used for checking, as well). Option 
\code{"thorough"} is many times slower. Default is \code{"thorough"}.}

\item{period}{\code{Character} value, aggregation period, i.e., the time 
period used to generate plots. One out of \code{"total"},\code{"yearly"}, 
\code{"monthly"}, \code{"weekly"}, \code{"daily"}. Default is 
\code{"weekly"}.}

\item{format}{\code{Character} value, seismic data format. One out of 
\code{"sac"} and \code{"mseed"}. Default is \code{"sac"}.}

\item{duration_set}{\code{Numeric} value, anticipated length of the seismic 
time series of the files to test in seconds. Default is \code{3600} (one 
hour).}

\item{plot}{\code{Logical} value, option to visualise the output of the 
function. Default is \code{TRUE}.}
}
\value{
\code{Data frame} containing check results and meta data.
}
\description{
The function checks seismic files organised by \code{aux_organisecubefiles} 
or \code{aux_organisecentaurfiles} for completeness. The tests include 
agreement of file name and seismic file meta data.
}
\examples{

\dontrun{

## set seismic data directory
dir_data <- paste0(system.file("extdata", package="eseis"), "/")

## check data archive for record completeness
chk <- aux_checkfiles(dir = dir_data, 
                      station = "RUEG1", 
                      component = "BHZ",
                      plot = TRUE)

}

}
\author{
Michael Dietze
}
\keyword{eseis}
