% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toy_load_patient.R
\name{toy.load.patient}
\alias{toy.load.patient}
\title{Load a toy patient for test}
\usage{
toy.load.patient(
  modality = c("ct", "mr", "rtdose", "rtstruct"),
  roi.name = c("eye", "optical nerve", "brain", "labyrinth processing unit",
    "energy unit", "gizzard", "ghost container", "exhaust valve"),
  dxyz = c(1, 1, 1),
  beam.nb = 7
)
}
\arguments{
\item{modality}{String vector, whose elements are chosen among the modalities
"ct", "mr", "rtstruct" and "rtdose".}

\item{roi.name}{String vector, whose elements are chosen among the regions of
interest (RoI) "eye", "optical nerve", "brain", "labyrinth processing unit",
"energy unit", "gizzard", "ghost container" and "exhaust valve". Note that the
RoI "couch", "patient" and "ptv" are still present.}

\item{dxyz}{Vector of length 3, representing the x, y, z steps in mm, between
ct, mr and rtdose voxels.}

\item{beam.nb}{Positive integer. Number of radiotherapy beams in rtdose modality.}
}
\value{
Returns an toy object of "patient" class, containing the modalities
defined in \code{modality}. See \link[espadon]{espadon.class} for class definitions.
}
\description{
The \code{toy.load.patient} creates a dummy "patient" class object.
It is used for the test.
}
\examples{
# loading of toy-patient objects (decrease dxyz for  better result)
step <- 5
pat <- toy.load.patient (dxyz = rep (step, 3), beam.nb = 1)
str (pat, max.level = 2)
}
