% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_missings.R
\name{recode_missings}
\alias{recode_missings}
\alias{recode_numeric_missing}
\alias{recode_strings_missing}
\title{Recode pre-defined missing values as NA}
\usage{
recode_missings(ess_data, missing_codes)

recode_numeric_missing(x, missing_codes)

recode_strings_missing(y, missing_codes)
}
\arguments{
\item{ess_data}{data frame or \code{\link[tibble]{tibble}} with data from the
European Social Survey. This data frame should come either
from \code{\link{import_rounds}}, \code{\link{import_country}} or read with
\code{\link[haven]{read_dta}} or \code{\link[haven]{read_spss}}. This is the case because it
identifies missing values using \code{\link[haven]{labelled}} classes.}

\item{missing_codes}{a character vector with values 'Not applicable',
'Refusal', 'Don't Know', 'No answer' or 'Not available'. By default
all values are chosen. Note that the wording is case sensitive.}

\item{x}{a \code{\link[haven]{labelled}} numeric}

\item{y}{a character vector}
}
\value{
The same data frame or \code{\link[tibble]{tibble}} but with values 'Not applicable',
'Refusal', 'Don't Know', 'No answer' and 'Not available' recoded
as NA.
}
\description{
Data from the European Social Survey is always accompanied by a script
that recodes the categories 'Not applicable', 'Refusal', 'Don't Know',
'No answer' and 'Not available' to missing. This function recodes
these categories to NA
}
\details{
When downloading data directly from the European Social Survey's website,
the downloaded .zip file contains a script that recodes some categories
as missings in Stata and SPSS formats. 

For recoding numeric variables \code{recode_numeric_missings}
uses the labels provided by the \code{\link[haven]{labelled}}
class to delete the labels matched in \code{missing_codes}. For the
character variables matching is done with the underlying number assigned to
each category, namely 6, 7, 8, 9 and 9 for 'Not applicable', Refusal',
'Don't Know', No answer' and 'Not available'.

The functions are a direct translation of the Stata script that comes
along when downloading one of the rounds. The Stata script is the same
for all rounds and all countries, meaning that these functions work
for all rounds.
}
\examples{
\dontrun{
seven <- ess_rounds(7, your_email)

attr(seven$tvtot, "labels")
mean(seven$tvtot, na.rm = TRUE)

names(table(seven$lnghom1))
# First three are actually missing values

seven_recoded <- recode_missings(seven)

attr(seven_recoded$tvtot, "labels")
# All missings have been removed
mean(seven_recoded$tvtot, na.rm = TRUE)

names(table(seven_recoded$lnghom1))
# All missings have been removed

# If you want to operate on specific variables
# you can use other recode_*_missing 

seven$tvtot <- recode_numeric_missing(seven$tvtot)

# Recode only 'Don't know' and 'No answer' to missing
seven$tvpol <- recode_numeric_missing(seven$tvpol, c("Don't know", "No answer"))


# The same can be done with recode_strings_missing
}

}
