% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{aquacomm_resps}
\alias{aquacomm_resps}
\title{Macroinvertebrate aquatic community formatted for univariate metrics.}
\format{
A data frame with five variables:
}
\source{
\code{
 aquacomm_resps <- aquacomm_fgps |>
 dplyr::select(-c(herb, detr_herb, omni, detr)) |>
 dplyr::group_by(time, treat) |>
 dplyr::summarize_at("carn", mean) |>
 dplyr::ungroup() |>
 tidyr::pivot_wider(names_from = treat,
 values_from = carn,
 names_prefix = "carn_") |>
 dplyr::select(time,
 "statvar_bl" = carn_0,
 "statvar_db" = carn_6)
 usethis::use_data(aquacomm_resps)
 }
}
\usage{
aquacomm_resps
}
\description{
Data frame created from \code{aquacomm_fgps}
}
\section{Fields}{

\describe{
\item{\code{time}}{sequential week number relative to the application of insecticide}

\item{\code{carn_0}}{mean abundance of carnivores in control replicates}

\item{\code{carn_0.1}}{mean abundance of carnivores in replicates subjected to pulse application of 0.1 nano g/L of chlorpyrifos insecticide}

\item{\code{carn_0.9}}{mean abundance of carnivores in replicates subjected to 0.9 nano g/L}

\item{\code{carn_6}}{mean abundance of carnivores in replicates subjected to 6 nano g/L}

\item{\code{carn_44}}{mean abundance of carnivores in replicates subjected to 44 nano g/L}
}}

\keyword{datasets}
