% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/car_parametric_tests.R
\name{car_parametric_tests}
\alias{car_parametric_tests}
\title{Returns the result of given event study parametric CAR tests.}
\usage{
car_parametric_tests(
  list_of_returns,
  car_start,
  car_end,
  percentage = 90,
  all = TRUE,
  tests
)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{car_start}{an object of \code{Date} class giving the first date of
the CAR period.}

\item{car_end}{an object of \code{Date} class giving the last date of the
CAR period.}

\item{percentage}{a lowest allowed percentage of non-missing observation
for each day to be incorporated into CAR. The default value is 90 percent.}

\item{all}{a logical value indicating whether all tests should be performed.
The default value is \code{TRUE}.}

\item{tests}{a list of tests' functions among \code{car_brown_warner_1985}
and \code{car_lamb}.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{name}: a name of the test
    \item \code{car_start}: the first date of the CAR period
    \item \code{car_end}: the last date of the CAR period
    \item \code{average_percentage}: an average share of non-missing
          observations over the CAR period
    \item \code{car_mean}: an average abnormal return over the CAR period
    \item \code{statistic}: a test's statistic
    \item \code{number_of_days}: the number of days in the CAR period
    \item \code{significance}: a significance of the statistic
}
}
\description{
Performs given tests to examine whether cumulative abnormal return (CAR)
significantly differs from zero.
}
\details{
\code{car_parametric_tests} performs specified tests among
\code{car_brown_warner_1985} and \code{lamb} and returns a list of these
tests' results. If \code{all = TRUE} (by default), the function ignores the
value of \code{tests}.
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^GSPC",
                                      start = as.Date("2019-04-01"),
                                      end = as.Date("2020-04-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("AMZN", "ZM", "UBER", "NFLX", "SHOP", "FB", "UPWK")
car_param <- get_prices_from_tickers(tickers,
                                                 start = as.Date("2019-04-01"),
                                                 end = as.Date("2020-04-01"),
                                                 quote = "Close",
                                                 retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2019-04-01"),
                       estimation_end = as.Date("2020-03-13")) \%>\%
    car_parametric_tests(car_start = as.Date("2020-03-16"),
                         car_end = as.Date("2020-03-20"))
}
## The result of the code above is equivalent to:
data(securities_returns)
car_param <- car_parametric_tests(
    list_of_returns = securities_returns,
    car_start = as.Date("2020-03-16"),
    car_end = as.Date("2020-03-20")
)

}
\references{
\itemize{
\item Brown S.J., Warner J.B. \emph{Using Daily Stock Returns, The Case of
Event Studies}. Journal of Financial Economics, 14:3-31, 1985.
\item Lamb R.P. \emph{An Exposure-Based Analysis of Property-Liability
Insurer Stock Values around Hurricane Andrew}. Journal of Risk and Insurance,
62(1):111-123, 1995.}
}
\seealso{
\code{\link{car_brown_warner_1985}} and \code{\link{car_lamb}}.
}
