% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{cdfs}
\alias{cdfs}
\title{Compute the empirical distribution functions for each of several groups.}
\usage{
cdfs(formula, data)
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups.}

\item{data}{The data frame that the data in the formula come from.}
}
\value{
A list with one function per group (level in the grouping factor).
}
\description{
This function is a simple wrapper that splits the data frame by the 
grouping variable, then loops \link[stats]{ecdf} through the split
data to return a CDF function for each group.
}
\examples{
cdfs(math ~ condition, star)
}
