% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_calcs.R
\name{tpac}
\alias{tpac}
\title{Transformed proportion above the cut}
\usage{
tpac(formula, data, cut, ref_group = NULL, diff = TRUE, tidy = TRUE)
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{cut}{The point at the scale from which the proportion above should
be calculated from.}

\item{ref_group}{Optional. If the name of the reference group is provided
(must be character and match the grouping level exactly), only the
estimates corresponding to the given reference group will be returned.}

\item{diff}{Logical, defaults to \code{TRUE}. Should the difference between
the groups be returned? If \code{FALSE} the raw proportion above
the cut is returned for each group.}

\item{tidy}{Logical. Should the data be returned in a tidy data frame? (see
\href{https://www.jstatsoft.org/article/view/v059i10}{Wickham, 2014}). If
false, effect sizes returned as a matrix or vector (depending on other
arguments passed).}
}
\value{
A tidy data frame (or vector) of the transformed proportion above
the cutoff. Optionally (and by default) all pairwise comparisons are 
calculated and returned.
}
\description{
This function transforms calls to \link{pac} into standard deviation units.
Function assumes that each distribution is distributed normally with 
common variances. See 
\href{http://journals.sagepub.com/doi/abs/10.3102/1076998611411918}{Ho &
 Reardon, 2012}
}
\examples{
# Compute transformed PAC differences for all pairwise comparisons 
# for each of three cuts
tpac(reading ~ condition, 
		star, 
		cut = c(450, 500, 550)) 

# Report raw transformed PAC, instead of differences in transformed PAC
tpac(reading ~ condition, 
		star, 
		cut = c(450, 500, 550), 
		diff = FALSE) 

# Report transformed differences with regular-sized classrooms as the
# reference group
tpac(reading ~ condition, 
		star, 
		cut = c(450, 500, 550), 
		ref_group = "reg") 

# Return a matrix instead of a data frame 
# (returns a vector if only one cut is provided)
tpac(reading ~ condition, 
		star, 
		cut = c(450, 500, 550), 
		ref_group = "reg",
		tidy = FALSE) 
}
