% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{src_mysql_cnf}
\alias{src_mysql_cnf}
\title{Connect to local MySQL Server using ~/.my.cnf}
\usage{
src_mysql_cnf(dbname = "test", groups = "rs-dbi", ...)
}
\arguments{
\item{dbname}{name of the local database you wish to connect to. Default is
\code{test}, as in \code{\link[RMySQL]{mysqlHasDefault}}.}

\item{groups}{section of \code{~/.my.cnf} file. Default is \code{rs-dbi} as in
\code{\link[RMySQL]{mysqlHasDefault}}}

\item{...}{arguments passed to \code{\link[dplyr]{src_mysql}}}
}
\description{
Connect to local MySQL Server using ~/.my.cnf
}
\examples{
if (require(RMySQL) && mysqlHasDefault()) {
  # connect to test database using rs-dbi
  db <- src_mysql_cnf()
  class(db)
  db
  # connect to another server using the 'client' group
  src_mysql_cnf(groups = "client")
}
}
\seealso{
\code{\link[dplyr]{src_mysql}}, \code{\link[RMySQL]{mysqlHasDefault}}
}
