% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{users}
\alias{user_add}
\alias{user_delete}
\alias{user_get}
\alias{user_list}
\alias{users}
\title{etcd authentication - users}
\arguments{
\item{user}{(character) User name to create/delete}

\item{password}{(character) Password to give the new user}

\item{roles}{(list/character vector) Roles to give the new user}

\item{auth_user, auth_pwd}{(character) Username and password for the authenticated user,
the root user}

\item{...}{Further args passed on to \code{\link[httr]{GET}},
\code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}
}
\value{
see return for each method
}
\description{
etcd authentication - users
}
\section{Methods}{

\itemize{
 \item user_list: list users, a list of users
 \item user_add: add a user, a list with slots \code{user} and \code{roles}
 \item user_get: get a user by name, a list with slots \code{user}
 and \code{roles} (if any exist)
 \item user_delete: delete a user by name, returns nothing on success
}
}
\examples{
\dontrun{
# make a client
cli <- etcd()

# Add user
cli$user_add("jane", "janepwd", "root", "pickbetterpwd")

# List users
cli$user_list()

# Get a single user
cli$user_get("root")
cli$user_get("jane")

# Delete user
cli$user_delete("jane", "root", "pickbetterpwd")
}
}

