% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy.R
\name{energydist}
\alias{energydist}
\title{Naive computation for Energy Distance}
\usage{
energydist(X, Y, pval = TRUE, numperm = 200, seednum = 0)
}
\arguments{
\item{X}{Matrix (or vector) of observations in first sample.}

\item{Y}{Matrix (or vector) of observations in second sample.}

\item{pval}{Boolean for whether to compute p-value or not.}

\item{numperm}{Number of permutations. Default is \code{200}.}

\item{seednum}{Seed number for generating permutations. Default is \code{0},
which means seed is set randomly. For values larger than
\code{0}, results will be reproducible.}
}
\value{
A list with the following elements:
\describe{
\item{\code{pval}}{The p-value of the test, if it is
computed (\code{pval=TRUE}). }
\item{\code{stat}}{The statistic of the test, which
is always computed. }
}
}
\description{
Computes energy distance, and possibly a p-value.
Suitable for multivariate data. Naive approach, quadratic in number
of observations.
}
\details{
First checks number of columns (dimension) are equal.
Suppose matrix \eqn{X} has \eqn{n} rows and \eqn{d} columns,
and matrix \eqn{Y} has \eqn{m} rows; checks that \eqn{Y}
has \eqn{d} columns (if not, then throws error).
Then flattens matrices to vectors (or, if \eqn{d=1}, they are
already vectors.
Then calls C++ method. If the first sample has \eqn{n}
\eqn{d}-dimensional samples and the second sample has
\eqn{m} \eqn{d}-dimensional samples, then the algorithm
computes the statistic in \eqn{O((n+m)^2)} time.

Random seed is set for \code{std::mt19937} and \code{std::shuffle} in C++.
}
\examples{

X <- matrix(c(1:12), ncol=2, byrow=TRUE)
Y <- matrix(c(13:20), ncol=2, byrow=TRUE)
energydistList <- energydist(X=X, Y=Y, pval=FALSE)

#computing p-value
energydistList <- energydist(X=X, Y=Y)
\donttest{
#computing p-value
#using 1000 permutations and seed 1 for reproducibility.
energydistList <- energydist(X=X, Y=Y, numperm=1000, seednum=1)
}

}
\references{
Baringhaus L. and Franz C. (2004) "On a new multivariate two-sample test."
Journal of multivariate analysis 88(1):190-206

Szekely G. J. and Rizzo M. L. (2004) "Testing for equal distributions in
high dimension." InterStat 5(16.10):1249-1272
}
