% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_variables_in_inventory.R
\name{compare_variables_in_inventory}
\alias{compare_variables_in_inventory}
\title{Compare an EURO-CORDEX inventory for different variables}
\usage{
compare_variables_in_inventory(data_inventory, vars = NULL)
}
\arguments{
\item{data_inventory}{A data.table as resulting from
\code{\link{get_inventory}}.}

\item{vars}{Character vector of variables to compare. If \code{NULL}, will use
all variables in \code{data_inventory}.}
}
\value{
The casted data.table with boolean columns if all years and number of
  files are equal for all variables.
}
\description{
Casts the result from \code{\link{get_inventory}} for different variables in
order to compare completeness of the inventory. Adds columns for checking
equality of years and number of files.
}
\examples{
\dontrun{

path <- "/mnt/CEPH_BASEDATA/METEO/SCENARIO"
dat <- get_inventory(path)
dat_compare <- compare_variables_in_inventory(dat, c("tas","rsds","pr"))
}
}
