% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_eurostat.R
\name{label_eurostat}
\alias{label_eurostat}
\alias{label_eurostat_vars}
\alias{label_eurostat_tables}
\title{Get Eurostat Codes}
\usage{
label_eurostat(x, dic = NULL, code = NULL, eu_order = FALSE,
  lang = "en", fix_duplicated = FALSE)

label_eurostat_vars(x, lang = "en")

label_eurostat_tables(x, lang = "en")
}
\arguments{
\item{x}{A character or a factor vector or a data_frame.}

\item{dic}{A string (vector) naming eurostat dictionary or dictionaries.
If \code{NULL} (default) dictionry names taken from column names of
the data_frame.}

\item{code}{For data_frames names of the column for which also code columns
should be retained. The suffix "_code" is added to code column names.}

\item{eu_order}{Logical. Should Eurostat ordering used for label levels.
Affects only factors.}

\item{lang}{A character, code for language. Available are "en" (default),
"fr" and "de".}

\item{fix_duplicated}{A logical. If TRUE, the code is added to the
duplicated label values. If FALSE (default) error is given if 
labelling produce duplicates.}
}
\value{
a vector or a data_frame.
}
\description{
Get definitions for Eurostat codes from Eurostat dictionaries.
}
\details{
A character or a factor vector of codes returns a corresponding 
   vector of definitions. \code{label_eurostat} labels also data_frames from 
   \code{\link{get_eurostat}}. For vectors a dictionary name have to be 
   supplied. For data_frames dictonary names are taken from column names. 
   "time" and "values" columns are returned as they were, so you can supply 
   data_frame from \code{\link{get_eurostat}} and get data_frame with 
   definitions instead of codes.
   
   Some Eurostat dictionaries includes dublicated labels. By default 
   dublicated labels cause an error, but they can be fixed automatically 
   with \code{fix_duplicated = TRUE}.
}
\section{Functions}{
\itemize{
\item \code{label_eurostat_vars}: Get definitions for variable (column) names. For
objects other than characters or factors definitions are get for names.

\item \code{label_eurostat_tables}: Get definitions for table names
}}

\examples{
 \dontrun{
   lp <- get_eurostat("nama_aux_lp")
   lpl <- label_eurostat(lp)
   str(lpl)
   lpl_order <- label_eurostat(lp, eu_order = TRUE)
   lpl_code <- label_eurostat(lp, code = "unit")
   label_eurostat_vars(names(lp))
   label_eurostat_tables("nama_aux_lp")
 }
}
\author{
Janne Huovari \email{janne.huovari@ptt.fi}
}
