% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{MarginalGPDLikelihood}
\alias{MarginalGPDLikelihood}
\title{Computes Generalised Pareto (log-)likelihood on non-zero exceedances under
independence.}
\usage{
MarginalGPDLikelihood(values, fixed_names, fixed_params, params,
  model_vars_names, logscale = T, transformation = F, n.moments = 4)
}
\arguments{
\item{values}{Vector of target values.}

\item{fixed_names}{Vector of literal names of parameters to keep fixed.}

\item{fixed_params}{Vector of numerical values of fixed parameters.}

\item{params}{List of parameters.}

\item{model_vars_names}{Vector of all parameters names in the model.}

\item{logscale}{Logical; Default (\code{TRUE}) is to use logscale (log-likelihood).}

\item{transformation}{Boolean to use the Marginal Transform (MT) method.}

\item{n.moments}{Number of moments the transformed variables should have
using the Marginal Transform (MT) method.}
}
\value{
Generalised Pareto (log-)likelihood on non-zero exceedances under
  independence.
}
\description{
Computes Generalised Pareto (log-)likelihood on non-zero exceedances under
independence.
}
\examples{
times <- c(1,2,3,4,5)
values <- c(2,0,3,4,0)
delta <- 2
fixed_names <- c("alpha", "kappa")
params <- c(3.4, 0.1)
fixed_params <- c(2.0, 4.3)
model_vars_names <- c("alpha", "beta", "rho", "kappa")
MarginalGPDLikelihood(values, fixed_names, fixed_params, params, model_vars_names)

}
