% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_8h_max.R
\name{extract_max_8h}
\alias{extract_max_8h}
\title{Create a NetCDF file with the surface maximum of O3}
\usage{
extract_max_8h(
  filelist,
  variable = "o3",
  field = "4d",
  prefix = "max_8h",
  units = "ug m-3",
  meta = TRUE,
  filename,
  verbose = TRUE
)
}
\arguments{
\item{filelist}{list of files to be read}

\item{variable}{variable name}

\item{field}{'4d' (default), '3d', '2d' or '2dz' see notes}

\item{prefix}{to output file, default is serie}

\item{units}{units on netcdf file (default is ug m-3), change to skip unit conversion}

\item{meta}{use Times, XLONG and XLAT data (only works with 2d variable for file)}

\item{filename}{name for the file, in this case prefix is not used}

\item{verbose}{display additional information}
}
\value{
No return value
}
\description{
Read the values from o3 and T2, convert o3 to ug m-3 and calculate the maximum of 8-hour moving avarage from a list of files.
}
\note{
The field argument '4d' / '2dz' is used to read a 4d/3d variable droping the 3rd dimention (z).
}
\examples{
dir.create(file.path(tempdir(), "MDA8"))
folder <- system.file("extdata",package="eva3dm")
wrf_file <- paste0(folder,"/test_small_o3.nc")
extract_max_8h(filelist = wrf_file,
               prefix = paste0(file.path(tempdir(),"MDA8"),'/mean'),
               field = '3d')

}
