% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_mean.R
\name{extract_mean}
\alias{extract_mean}
\title{Create a NetCDF file with the surface mean}
\usage{
extract_mean(
  filelist,
  variable = "o3",
  field = "4d",
  prefix = "mean",
  units = "ppmv",
  meta = TRUE,
  filename,
  verbose = TRUE
)
}
\arguments{
\item{filelist}{list of files to be read}

\item{variable}{variable name}

\item{field}{'4d' (default), '3d', '2d' or '2dz' see notes}

\item{prefix}{to output file, default is serie}

\item{units}{units on netcdf file (default is ppmv)}

\item{meta}{use Times, XLONG and XLAT data (only works with 2d variable for file)}

\item{filename}{name for the file, in this case prefix is not used}

\item{verbose}{display additional information}
}
\value{
No return value
}
\description{
Read and calculate the mean value of a variable from a list of wrf output files.
}
\note{
The field argument '4d' / '2dz' is used to read a 4d/3d variable droping the 3rd dimention (z).
}
\examples{
dir.create(file.path(tempdir(), "MEAN"))
folder <- system.file("extdata",package="eva3dm")
wrf_file <- paste0(folder,"/wrf.day1.o3.nc")
extract_mean(filelist = wrf_file,prefix = paste0(file.path(tempdir(),"MEAN"),'/mean'))

}
