% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{pmodavg}
\alias{pmodavg}
\title{Distribution function for model averaging of Weibull and log-normal}
\usage{
pmodavg(t, theta, w1, q, x, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{t}{The vector of time points.}

\item{theta}{The parameter vector consisting of the accelerate failure
time (AFT) regression coefficients and the logrithm of the AFT
regression scale parameter for the Weibull and log-normal distributions.}

\item{w1}{The weight for the Weibull component distribution.}

\item{q}{The number of elements in the vector of covariates.}

\item{x}{The vector of covariates (excluding the intercept).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
the distribution function, otherwise, the survival function.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
The probabilities p = P(T <= t | X = x).
}
\description{
Obtains the distribution function value for model-averaging
of Weibull and log-normal regression.
}
\keyword{internal}
