% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{pwexpreg}
\alias{pwexpreg}
\title{Piecewise exponential regression}
\usage{
pwexpreg(time, event, J, tcut, q = 0, x = 1)
}
\arguments{
\item{time}{The survival time.}

\item{event}{The event indicator.}

\item{J}{The number of time intervals.}

\item{tcut}{A vector that specifies the endpoints of time intervals
for the baseline piecewise exponential survival distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2 event
intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{q}{The number of columns of the covariates matrix
(exluding the intercept).}

\item{x}{The covariates matrix (including the intercept).}
}
\value{
The maximum likelihood estimates and the associated
covariance matrix, AIC and BIC.
}
\description{
Obtains the maximum likelihood estimates for piecewise
exponential regression.
}
