% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fpsdengpd.r
\name{fpsdengpd}
\alias{fpsdengpd}
\alias{lpsdengpd}
\alias{nlpsdengpd}
\alias{nlupsdengpd}
\alias{proflupsdengpd}
\title{MLE Fitting of P-splines Density Estimate for Bulk and GPD Tail Extreme Value Mixture Model}
\usage{
fpsdengpd(x, phiu = TRUE, useq = NULL, fixedu = FALSE, pvector = NULL,
  lambdaseq = NULL, breaks = NULL, xrange = NULL, nseg = 10,
  degree = 3, design.knots = NULL, ord = 2, std.err = TRUE,
  method = "BFGS", control = list(maxit = 10000), finitelik = TRUE, ...)

lpsdengpd(x, psdenx, u = NULL, sigmau = NULL, xi = 0, phiu = TRUE,
  bsplinefit = NULL, phib = NULL, log = TRUE)

nlpsdengpd(pvector, x, psdenx, phiu = TRUE, bsplinefit, phib = NULL,
  finitelik = FALSE)

proflupsdengpd(u, pvector, x, psdenx, phiu = TRUE, bsplinefit,
  method = "BFGS", control = list(maxit = 10000), finitelik = FALSE, ...)

nlupsdengpd(pvector, u, x, psdenx, phiu = TRUE, bsplinefit = bsplinefit,
  phib = NULL, finitelik = FALSE)
}
\arguments{
\item{x}{vector of sample data}

\item{phiu}{probability of being above threshold \eqn{(0, 1)} or logical, see Details in
help for \code{\link[evmix:fnormgpd]{fnormgpd}}}

\item{useq}{vector of thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedu}{logical, should threshold be fixed (at either scalar value in \code{useq},
or estimated from maximum of profile likelihood evaluated at
sequence of thresholds in \code{useq})}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{lambdaseq}{vector of \eqn{\lambda}'s (or scalar) to be considered in profile likelihood. Required.}

\item{breaks}{histogram breaks (as in \code{\link[graphics:hist]{hist}} function)}

\item{xrange}{vector of minimum and maximum of B-spline (support of density)}

\item{nseg}{number of segments between knots}

\item{degree}{degree of B-splines (0 is constant, 1 is linear, etc.)}

\item{design.knots}{spline knots for splineDesign function}

\item{ord}{order of difference used in the penalty term}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{psdenx}{P-splines based density estimate for each datapoint in x}

\item{u}{scalar threshold value}

\item{sigmau}{scalar scale parameter (positive)}

\item{xi}{scalar shape parameter}

\item{bsplinefit}{list output from P-splines density fitting \code{\link[evmix:fpsden]{fpsden}} function}

\item{phib}{renormalisation constant for bulk model density \eqn{(1-\phi_u)/H(u)}, to make it integrate to \code{1-phiu}}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}
}
\value{
Log-likelihood is given by \code{\link[evmix:fpsdengpd]{lpsdengpd}} and it's
  wrappers for negative log-likelihood from \code{\link[evmix:fpsdengpd]{nlpsdengpd}}
  and \code{\link[evmix:fpsdengpd]{nlupsdengpd}}. Profile likelihood for single
  threshold given by \code{\link[evmix:fpsdengpd]{proflupsdengpd}}. Fitting function
  \code{\link[evmix:fpsdengpd]{fpsdengpd}} returns a simple list with the
  following elements

\tabular{ll}{
 \code{call}:          \tab \code{optim} call\cr
 \code{x}:             \tab data vector \code{x}\cr
 \code{init}:          \tab \code{pvector}\cr
 \code{fixedu}:        \tab fixed threshold, logical\cr
 \code{useq}:          \tab threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{nllhuseq}:      \tab profile negative log-likelihood at each threshold in useq\cr
 \code{bsplinefit}:    \tab complete \code{\link[evmix:fpsden]{fpsden}} output\cr
 \code{psdenx}:        \tab P-splines based density estimate for each datapoint in \code{x}\cr
 \code{xrange}:        \tab range of support of B-splines\cr
 \code{degree}:        \tab degree of B-splines\cr
 \code{nseg}:          \tab number of internal segments\cr
 \code{design.knots}:  \tab knots used in \code{\link[splines:splineDesign]{splineDesign}}\cr
 \code{nbinwidth}:     \tab scaling factor to convert counts to density\cr
 \code{optim}:         \tab complete \code{optim} output\cr
 \code{conv}:          \tab indicator for "possible" convergence\cr
 \code{mle}:           \tab vector of MLE of (GPD and threshold, if relevant) parameters\cr
 \code{cov}:           \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:            \tab vector of standard errors of MLE of parameters\cr
 \code{rate}:          \tab \code{phiu} to be consistent with \code{\link[evd:fpot]{evd}}\cr
 \code{nllh}:          \tab minimum negative log-likelihood\cr
 \code{n}:             \tab total sample size\cr
 \code{beta}:          \tab vector of MLE of B-spline coefficients\cr
 \code{lambda}:        \tab Estimated or fixed \eqn{\lambda}\cr
 \code{u}:             \tab threshold (fixed or MLE)\cr
 \code{sigmau}:        \tab MLE of GPD scale\cr
 \code{xi}:            \tab MLE of GPD shape\cr
 \code{phiu}:          \tab MLE of tail fraction (bulk model or parameterised approach)\cr
 \code{se.phiu}:       \tab standard error of MLE of tail fraction\cr
}
}
\description{
Maximum likelihood estimation for fitting the extreme value
mixture model with P-splines density estimate for bulk distribution upto the threshold and conditional
GPD above threshold. With options for profile likelihood estimation for threshold and
fixed threshold approach.
}
\details{
The extreme value mixture model with P-splines density estimate for bulk and GPD tail is
fitted to the entire dataset. A two-stage maximum likelihood inference approach is taken. The first
stage consists fitting of the P-spline density estimator, which is acheived by MLE using the
\code{\link[evmix:fpsden]{fpsden}} function. The second stage, conditions on the B-spline coefficients,
using MLE for the extreme value mixture model (GPD parameters and threshold, if requested). The estimated
parameters, variance-covariance matrix and their standard errors are automatically
output.

See help for \code{\link[evmix:fnormgpd]{fnormgpd}} for details of extreme value mixture models,
type \code{help fnormgpd}. Only the different features are outlined below for brevity.

As the second stage conditions on the Bs-pline coefficients, the full parameter vector is
(\code{u}, \code{sigmau}, \code{xi}) if threshold is also estimated and
(\code{sigmau}, \code{xi}) for profile likelihood or fixed threshold approach.

(Penalized) MLE estimation of the B-Spline coefficients is carried out using Poisson regression
based on histogram bin counts. See help for \code{\link[evmix:fpsden]{fpsden}} for details,
type \code{help fpsden}.
}
\note{
The data are both vectors. Infinite and missing sample values are dropped.

No initial values for the coefficients are needed.

It is advised to specify the range of support \code{xrange}, using finite end-points. This is
especially important when the support is bounded. By default \code{xrange} is simply the range of the
input data \code{range(x)}.

Further, it is advised to always set the histogram bin \code{breaks}, expecially if the support is bounded.
By default \code{10*ln(n)} equi-spaced bins are defined between \code{xrange}.

When \code{pvector=NULL} then the initial values are:
\itemize{
 \item threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of GPD parameters above threshold.
}
}
\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}.

  The Poisson regression and leave-one-out cross-validation functions
are based on the code of Eilers and Marx (1996) available from Brian Marx's website
\url{http://www.stat.lsu.edu/faculty/marx}, which is gratefully acknowledged.
}
\examples{
\dontrun{
set.seed(1)
par(mfrow = c(1, 1))

x = rnorm(1000)
xx = seq(-4, 4, 0.01)
y = dnorm(xx)

# Plenty of histogram bins (100)
breaks = seq(-4, 4, length.out=101)

# P-spline fitting with cubic B-splines, 2nd order penalty and 10 internal segments
# CV search for penalty coefficient.
fit = fpsdengpd(x, useq = seq(0, 3, 0.1), fixedu = TRUE,
             lambdaseq = 10^seq(-5, 5, 0.25), breaks = breaks,
             xrange = c(-4, 4), nseg = 10, degree = 3, ord = 2)

hist(x, freq = FALSE, breaks = breaks, xlim = c(-6, 6))
lines(xx, y, col = "black") # true density

# P-splines+GPD
with(fit, lines(xx, dpsdengpd(xx, beta, nbinwidth,
                              u = u, sigmau = sigmau, xi = xi, design = design.knots),
                lwd = 2, col = "red"))
abline(v = fit$u, col = "red", lwd = 2, lty = 3)

# P-splines density estimate
with(fit, lines(xx, dpsden(xx, beta, nbinwidth, design = design.knots),
                lwd = 2, col = "blue", lty = 2))

# vertical lines for all knots
with(fit, abline(v = design.knots, col = "red"))

# internal knots
with(fit, abline(v = design.knots[(degree + 2):(length(design.knots) - degree - 1)], col = "blue"))

# boundary knots (support of B-splines)
with(fit, abline(v = design.knots[c(degree + 1, length(design.knots) - degree)], col = "green"))

legend("topright", c("True Density","P-spline density","P-spline+GPD"),
  col=c("black", "blue", "red"), lty = c(1, 2, 1))
legend("topleft", c("Internal Knots", "Boundaries", "Extra Knots", "Threshold"),
  col=c("blue", "green", "red", "red"), lty = c(1, 1, 1, 2))
}
}
\author{
Alfadino Akbar and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

\url{http://en.wikipedia.org/wiki/Cross-validation_(statistics)}

\url{http://en.wikipedia.org/wiki/B-spline}

\url{http://www.stat.lsu.edu/faculty/marx}

Eilers, P.H.C. and Marx, B.D. (1996). Flexible smoothing with B-splines and penalties.
Statistical Science 11(2), 89-121.

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}
}
\seealso{
\code{\link[evmix:fpsden]{fpsden}}, \code{\link[evmix:normgpd]{fnormgpd}},
\code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}
}

