% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fkdengpd.r
\name{fkdengpd}
\alias{fkdengpd}
\alias{lkdengpd}
\alias{nlkdengpd}
\alias{proflukdengpd}
\alias{nlukdengpd}
\alias{lkdengpd}
\alias{fkdengpd}
\alias{nlkdengpd}
\alias{proflukdengpd}
\alias{nlukdengpd}
\alias{nlkdengpd}
\alias{fkdengpd}
\alias{lkdengpd}
\alias{proflukdengpd}
\alias{nlukdengpd}
\alias{proflukdengpd}
\alias{fkdengpd}
\alias{lkdengpd}
\alias{nlkdengpd}
\alias{nlukdengpd}
\alias{nlukdengpd}
\alias{fkdengpd}
\alias{lkdengpd}
\alias{nlkdengpd}
\alias{proflukdengpd}
\title{MLE Fitting of Kernel Density Estimate for Bulk and GPD Tail Extreme Value Mixture Model}
\usage{
fkdengpd(x, phiu = TRUE, useq = NULL, fixedu = FALSE, pvector = NULL,
  kernel = "gaussian", add.jitter = FALSE, factor = 0.1, amount = NULL,
  std.err = TRUE, method = "BFGS", control = list(maxit = 10000),
  finitelik = TRUE, ...)

lkdengpd(x, lambda = NULL, u = 0, sigmau = 1, xi = 0, phiu = TRUE,
  bw = NULL, kernel = "gaussian", log = TRUE)

nlkdengpd(pvector, x, phiu = TRUE, kernel = "gaussian", finitelik = FALSE)

proflukdengpd(u, pvector, x, phiu = TRUE, kernel = "gaussian",
  method = "BFGS", control = list(maxit = 10000), finitelik = TRUE, ...)

nlukdengpd(pvector, u, x, phiu = TRUE, kernel = "gaussian",
  finitelik = FALSE)
}
\arguments{
\item{x}{vector of sample data}

\item{phiu}{probability of being above threshold \eqn{(0, 1)} or logical, see Details in 
help for \code{\link[evmix:fnormgpd]{fnormgpd}}}

\item{useq}{vector of thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedu}{logical, should threshold be fixed (at either scalar value in \code{useq},
or estimated from maximum of profile likelihood evaluated at
sequence of thresholds in \code{useq})}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{kernel}{kernel name (\code{default = "gaussian"})}

\item{add.jitter}{logical, whether jitter is needed for rounded kernel centres}

\item{factor}{see \code{\link[base:jitter]{jitter}}}

\item{amount}{see \code{\link[base:jitter]{jitter}}}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{lambda}{scalar bandwidth for kernel (as half-width of kernel)}

\item{u}{scalar threshold value}

\item{sigmau}{scalar scale parameter (positive)}

\item{xi}{scalar shape parameter}

\item{bw}{scalar bandwidth for kernel (as standard deviations of kernel)}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}
}
\value{
Log-likelihood is given by \code{\link[evmix:fkdengpd]{lkdengpd}} and it's
  wrappers for negative log-likelihood from \code{\link[evmix:fkdengpd]{nlkdengpd}}
  and \code{\link[evmix:fkdengpd]{nlukdengpd}}. Profile likelihood for single
  threshold given by \code{\link[evmix:fkdengpd]{proflukdengpd}}. Fitting function
  \code{\link[evmix:fkdengpd]{fkdengpd}} returns a simple list with the
  following elements

\tabular{ll}{
 \code{call}:      \tab \code{optim} call\cr
 \code{x}:         \tab data vector \code{x}\cr
 \code{init}:      \tab \code{pvector}\cr
 \code{fixedu}:    \tab fixed threshold, logical\cr
 \code{useq}:      \tab threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{nllhuseq}:  \tab profile negative log-likelihood at each threshold in useq\cr
 \code{optim}:     \tab complete \code{optim} output\cr
 \code{mle}:       \tab vector of MLE of parameters\cr
 \code{cov}:       \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:        \tab vector of standard errors of MLE of parameters\cr
 \code{rate}:      \tab \code{phiu} to be consistent with \code{\link[evd:fpot]{evd}}\cr
 \code{nllh}:      \tab minimum negative log-likelihood\cr
 \code{n}:         \tab total sample size\cr
 \code{lambda}:    \tab MLE of lambda (kernel half-width)\cr
 \code{u}:         \tab threshold (fixed or MLE)\cr
 \code{sigmau}:    \tab MLE of GPD scale\cr
 \code{xi}:        \tab MLE of GPD shape\cr
 \code{phiu}:      \tab MLE of tail fraction (bulk model or parameterised approach)\cr
 \code{se.phiu}:   \tab standard error of MLE of tail fraction\cr
 \code{bw}:        \tab MLE of bw (kernel standard deviations)\cr
 \code{kernel}:    \tab kernel name\cr
}
}
\description{
Maximum likelihood estimation for fitting the extreme value 
mixture model with kernel density estimate for bulk distribution upto the threshold and conditional
GPD above threshold. With options for profile likelihood estimation for threshold and
fixed threshold approach.
}
\details{
The extreme value mixture model with kernel density estimate for bulk and GPD tail is 
fitted to the entire dataset using maximum likelihood estimation. The estimated
parameters, variance-covariance matrix and their standard errors are automatically
output.

See help for \code{\link[evmix:fnormgpd]{fnormgpd}} for details, type \code{help fnormgpd}. 
Only the different features are outlined below for brevity.

The full parameter vector is
(\code{lambda}, \code{u}, \code{sigmau}, \code{xi}) if threshold is also estimated and
(\code{lambda}, \code{sigmau}, \code{xi}) for profile likelihood or fixed threshold approach.

Cross-validation likelihood is used for KDE, but standard likelihood is used
for GPD component. See help for \code{\link[evmix:fkden]{fkden}} for details,
type \code{help fkden}.

The alternate bandwidth definitions are discussed in the 
\code{\link[evmix:kernels]{kernels}}, with the \code{lambda} as the default
used in the likelihood fitting. The \code{bw} specification is the same as
used in the \code{\link[stats:density]{density}} function.

The possible kernels are also defined in \code{\link[evmix:kernels]{kernels}}
with the \code{"gaussian"} as the default choice.
}
\note{
The data and kernel centres are both vectors. Infinite and missing sample values
(and kernel centres) are dropped.

When \code{pvector=NULL} then the initial values are:
\itemize{
 \item normal reference rule for bandwidth, using the \code{\link[stats:bandwidth]{bw.nrd0}} function, which is
   consistent with the \code{\link[stats:density]{density}} function. At least two kernel
   centres must be provided as the variance needs to be estimated.
 \item threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of GPD parameters above threshold. 
}
}
\section{Warning}{

See important warnings about cross-validation likelihood estimation in 
\code{\link[evmix:fkden]{fkden}}, type \code{help fkden}.
}

\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}. Based on code
by Anna MacDonald produced for MATLAB.
}

\examples{
\dontrun{
set.seed(1)
par(mfrow = c(2, 1))

x = rnorm(1000)
xx = seq(-4, 4, 0.01)
y = dnorm(xx)

# Bulk model based tail fraction
fit = fkdengpd(x)
hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dkdengpd(xx, x, lambda, u, sigmau, xi), col="red"))
abline(v = fit$u, col = "red")
  
# Parameterised tail fraction
fit2 = fkdengpd(x, phiu = FALSE)
with(fit2, lines(xx, dkdengpd(xx, x, lambda, u, sigmau, xi, phiu), col="blue"))
abline(v = fit2$u, col = "blue")
legend("topright", c("True Density","Bulk Tail Fraction","Parameterised Tail Fraction"),
  col=c("black", "red", "blue"), lty = 1)
  
# Profile likelihood for initial value of threshold and fixed threshold approach
fitu = fkdengpd(x, useq = seq(0, 2, length = 20))
fitfix = fkdengpd(x, useq = seq(0, 2, length = 20), fixedu = TRUE)

hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dkdengpd(xx, x, lambda, u, sigmau, xi), col="red"))
abline(v = fit$u, col = "red")
with(fitu, lines(xx, dkdengpd(xx, x, lambda, u, sigmau, xi), col="purple"))
abline(v = fitu$u, col = "purple")
with(fitfix, lines(xx, dkdengpd(xx, x, lambda, u, sigmau, xi), col="darkgreen"))
abline(v = fitfix$u, col = "darkgreen")
legend("topright", c("True Density","Default initial value (90\% quantile)",
 "Prof. lik. for initial value", "Prof. lik. for fixed threshold"),
 col=c("black", "red", "purple", "darkgreen"), lty = 1)
}
  
}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/Kernel_density_estimation}

\url{http://en.wikipedia.org/wiki/Cross-validation_(statistics)}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Hu, Y. (2013). Extreme value mixture modelling: An R package and simulation study.
MSc (Hons) thesis, University of Canterbury, New Zealand.
\url{http://ir.canterbury.ac.nz/simple-search?query=extreme&submit=Go}

Bowman, A.W. (1984). An alternative method of cross-validation for the smoothing of
density estimates. Biometrika 71(2), 353-360.

Duin, R.P.W. (1976). On the choice of smoothing parameters for Parzen estimators of
probability density functions. IEEE Transactions on Computers C25(11), 1175-1179.

MacDonald, A., Scarrott, C.J., Lee, D., Darlow, B., Reale, M. and Russell, G. (2011).
A flexible extreme value mixture model. Computational Statistics and Data Analysis
55(6), 2137-2157.

Wand, M. and Jones, M.C. (1995). Kernel Smoothing. Chapman && Hall.
}
\seealso{
\code{\link[evmix:kernels]{kernels}}, \code{\link[evmix:kfun]{kfun}},
 \code{\link[stats:density]{density}}, \code{\link[stats:bandwidth]{bw.nrd0}}
and \code{\link[ks:kde]{dkde}} in \code{\link[ks:kde]{ks}} package.
 \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}.

Other kdengpd kdengpdcon fkdengpd fkdengpdcon normgpd fnormgpd
         kden bckden bckdengpd bckdengpdcon fkden fbckden fbckdengpd fbckdengpdcon: \code{\link{fbckdengpdcon}},
  \code{\link{fbckdengpd}}, \code{\link{fkdengpdcon}}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
