% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.mode.shift.R
\name{fit.mode.shift}
\alias{fit.mode.shift}
\title{Fit two models to two separate segments to an evolutionary sequence (time-series).}
\usage{
fit.mode.shift(
  y,
  model1 = c("Stasis", "URW", "GRW", "OU"),
  model2 = c("Stasis", "URW", "GRW", "OU"),
  fit.all = FALSE,
  minb = 7,
  shift.point = NULL,
  pool = TRUE,
  silent = FALSE,
  hess = FALSE
)
}
\arguments{
\item{y}{an univariate evoTS object.}

\item{model1}{the model fitted to the first segment. Options are Stasis, URW, GRW, OU.}

\item{model2}{the model fitted to the second segment. Options are Stasis, URW, GRW, OU.}

\item{fit.all}{logical indicating whether to fit all pairwise combinations of the four models to the evolutionary sequence (time-series).}

\item{minb}{the minimum number of samples within a segment to consider}

\item{shift.point}{The sample that split the time-series into two segments. The samples are passed to the argument as a vector. Default is NULL, which means all possible shift points will be assessed constrained by how minb is defined.}

\item{pool}{logical indicating whether to pool variances across samples}

\item{silent}{if TRUE, less information is printed to the screen as the model is fit}

\item{hess}{logical, indicating whether to calculate standard errors from the Hessian matrix.

#'}
}
\value{
the function  returns a list of all investigated models and their highest log-likelihood (and their corresponding AICc and AICc weight).
\item{logL}{the log-likelihood of the optimal solution}
\item{AICc}{AIC with a correction for small sample sizes}
\item{parameters}{parameter estimates}
\item{modelName}{abbreviated model name}
\item{method}{Joint consideration of all samples}
\item{K}{number of parameters in the model}
\item{n}{the number of observations/samples}
\item{all.logl}{log-likelihoods for all tested partitions of the series into segments. Will return a single value if shift points have been given}
\item{GG}{matrix of indices of initial samples of each tested segment configuration; each column of GG corresponds to the elements of all.logl}

In addition, if fit.all=TRUE the function also returns a list of all investigated models and their highest log-likelihood (and their corresponding AICc and AICc weight).
}
\description{
Wrapper function to find maximum likelihood solutions to two models to an evolutionary sequence.
}
\note{
The models have been implemented to be compatible with the joint parameterization routine in the package paleoTS. The optimization is therefore fit using the actual sample values, with the autocorrelation among samples accounted for in the log-likelihood function. The joint distribution of sample means is multivariate normal, with means and variance-covariances determined by evolutionary parameters and sampling errors.
}
\examples{

##Generate a paleoTS object.
x <- paleoTS::sim.GRW(30)

## Fit a mode-shift model without defining a shift point (the example may take > 5 seconds to run)
fit.mode.shift(x, model1="URW", model2="Stasis")
}
\references{
Hunt, G. 2006. Fitting and comparing models of phyletic evolution: random walks and beyond. \emph{Paleobiology} 32:578–601

Hunt, G., Bell, M. A. & Travis, M. P. Evolution towards a new adaptive optimum: Phenotypic evolution in a fossil stickleback lineage. \emph{Evolution} 62:700–710 (2008)
}
\author{
Kjetil Lysne Voje
}
