% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logL.joint.OU.BM.R
\name{logL.joint.OU.BM}
\alias{logL.joint.OU.BM}
\title{Log-likelihoods for evolutionary models}
\usage{
logL.joint.OU.BM(p, y, opt.anc)
}
\arguments{
\item{p}{parameters of the model to be optimized}

\item{y}{a paleoTS object}

\item{opt.anc}{logical, indicating if the ancestral trait value is at the optimum (TRUE) or displaced from the optimum (FALSE)}
}
\value{
The log-likelihood of the parameter estimates, given the data.
}
\description{
Returns log-likelihood for an Ornstein-Uhlenbeck model where the optimum evolves as a Unbiased Random Walk. The movement of the optimum is not parameterized based on separate data.
}
\details{
In general, users will not be access these functions directly, but instead use the optimization functions, which use these functions to find the best-supported parameter values.
}
\references{
Hansen, T. F., Pienaar, J. & Orzack, S. H. A Comparative Method for Studying Adaptation to a Randomly Evolving Environment. \emph{Evolution} 62, 1965–1977 (2008).
}
\author{
Kjetil Lysne Voje
}
