% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/randomBeta.R
\name{randomBeta}
\alias{randomBeta}
\title{Generating selection gradients/vectors in random directions.}
\usage{
randomBeta(n = 1, k = 2)
}
\arguments{
\item{n}{Number of selection gradients/vectors.}

\item{k}{Number of dimensions.}
}
\value{
\code{randomBeta} returns a matrix where the vectors are stacked column wise.
}
\description{
\code{randomBeta} generates unit length vectors (selection gradients)
uniformly distributed in a k-dimensional hypersphere.
}
\details{
\code{randomBeta} exploits the spherical symmetry of a multidimensional
Gaussian density function. Each element of each vector is randomly sampled
from a univariate Gaussian distribution with zero mean and unit variance. The
vector is then divided by its norm to standardize it to unit length.
}
\examples{
## Two vectors of dimension 3:
randomBeta(n = 2, k = 3)
}
\author{
Geir H. Bolstad
}

