% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{inference}
\alias{inference}
\title{Approximate and exact tests for single data set}
\usage{
inference(y0, n0, y1, n1, psi = 0, sided = 1, dec.places = 4)
}
\arguments{
\item{y0}{number of successes for control}

\item{n0}{control sample size}

\item{y1}{number of successes for treatment}

\item{n1}{treatment sample size}

\item{psi}{null value of risk difference p1-p0}

\item{sided}{1-sided or 2-sided test}

\item{dec.places}{decimal places of output T and P values}
}
\value{
List with elements \item{y}{the data vector y0,y1} \item{n}{the
sample size vector n0,n1} \item{approx}{approximate T-value and p-value}
\item{quasi.exact}{quasi.exact T-value and p-value} \item{pmle}{profile
maximum likelihood estimate of baseline probability} \item{psi}{null value
of p1-p0}
}
\description{
For a single provided data sets (y0, n0, y1, n1) approximate and exact tests
of the null value p1-p0=psi are calculated.
}
\examples{

y0=25
y1=41
n0=65
n1=82
# Non-inferiority test of p1-p0>-0.1. Evidence is strong.
inference(y0,n0,y1,n1,psi=-0.1)


}
\references{
C.J. Lloyd & R. Ripamonti (2021) A comprehensive open-source
library for exact required sample size in binary clinical trials.
Contemporary Clinical Trials 107. \doi{10.1016/j.cct.2021.106491}
}
\author{
Chris J. Lloyd
}
