% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fns.R
\name{make.Gmatrix}
\alias{make.Gmatrix}
\title{G-matrix}
\usage{
make.Gmatrix(n)
}
\arguments{
\item{n}{The number of observed parameters, mutation sites, etc.}
}
\value{
A matrix that is 2^n-by-2^n.
}
\description{
The G-matrix is the operator used for calculating a vector of effects from a
vector of responses, up to arbitrary interaction order. This recursive function
for building up the G-matrix is presented in a paper about genetic epistasis
from Poelwijk, Krishna, and Ranganathan (2016, PLOS Comp Bio
\doi{10.1371/journal.pcbi.1004771}). When the G-matrix is
multiplied on the right by a column vector of the observed responses, it will
produce a column vector of the effects. In other words, the G-matrix adds and
subtracts off the appropriate lower-order terms to arrive at the correct values
of interaction effects.
}
\examples{
Gmat<- make.Gmatrix(3)
}
