% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumberProperties.R
\name{divisor_25}
\alias{divisor_25}
\alias{denominator_25}
\alias{deonom_25}
\alias{is_terminal}
\alias{round_25}
\alias{prime_numbers}
\alias{primes}
\alias{has_digits}
\alias{all_integer}
\alias{only_digits}
\alias{is_term}
\alias{denom_25}
\title{Number Properties}
\usage{
divisor_25(x)

denominator_25(x)

is_terminal(x)

round_25(x)

prime_numbers(n, sieve = FALSE)

primes(x, min = 2)

has_digits(
  x,
  digits = 2,
  tol = 10^{
     -digits - 6
 }
)

all_integer(x)

only_digits(
  x,
  digits = 2,
  tol = 10^{
     -digits - 6
 }
)

is_term(x)

denom_25(x)
}
\arguments{
\item{x}{numeric: values to test/check}

\item{n}{integer: find all prime numbers up to n}

\item{sieve}{logical: should in any case the Sieve of Eratosthenes be used to compute prime numbers (default: \code{FALSE})}

\item{min}{integer: the minimum prime number used (default: \code{2})}

\item{digits}{numeric: number of digits to check (default: \code{2})}

\item{tol}{numeric: max. deviation from the rounded \code{x} (default: \code{1e-6})}
}
\value{
logical
}
\description{
\itemize{
\item \code{is_terminal} checks whether \code{x}'s can be expressed as a terminal fraction, basically \code{divisor_25(denominator(x))}
\item \code{divisor_25} checks whether all \code{x}'s can be expressed as \eqn{2^x 5^y}
\item \code{prime_numbers} returns all prime numbers up to a limit
\item \code{primes} prime factorization of \code{x}, returns a matrix with the power of each prime number
\item \code{has_digits} checks whether the \code{x}'s have only \code{digits} after the decimal point, basically \code{abs(x-round(x, digits))<tol}
\item \code{all_integer} checks whether all \code{x}'s are integer, basically \code{all(has_digits(x,0))}
}
}
\examples{
is_terminal(2/3)   # 0.6666... non-terminal
is_terminal(1/5)   # 0.2       terminal
divisor_25(1:25)
prime_numbers(100) # all prime numbers less equal 100
primes(1:20)       # prime factorization of 1 to twenty
}
