% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperloop.R
\name{gsimplify}
\alias{gsimplify}
\alias{simplify_hyperloop}
\alias{simple_hloop}
\title{Simplified \code{hyperloop} Object}
\usage{
gsimplify(ga, exclude = NULL, subset = NULL)

simplify_hyperloop(ga, exclude = NULL, subset = NULL)

simple_hloop(ga, exclude = NULL, subset = NULL)
}
\arguments{
\item{ga}{list: of a \code{hyperloop} object}

\item{exclude}{character or integer: elements to exclude in each list element of \code{ga} (default: \code{NULL})}

\item{subset}{indices specifying elements of \code{ga} to extract (default: \code{NULL})}
}
\value{
A data frame if possible, otherwise a list.
}
\description{
Simplifies a \code{hyperloop} object if possible.
}
\examples{
# calls: t.test(x, -1), t.test(x, 0), t.test(x, 1)
ga <- gapply(t.test, x=I(rnorm(100)), mu=-1:1)
# no simplication since `data.name` and `conf.int` have lengths larger  than one
gsimplify(ga)
#' simplification is now possible
gsimplify(ga, exclude=c("conf.int", "data.name"))
}
