% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexing.R
\name{compare_index}
\alias{compare_index}
\title{Compares two indexes}
\usage{
compare_index(pheno, index1, index2)
}
\arguments{
\item{pheno}{A data.frame of the samples with the characteristics to normalize.}

\item{index1, index2}{A list with the index for each sample, the name of the
column in \code{pheno} with the batch subset or the character .}
}
\value{
A matrix with the variables and the columns of of each batch.
Negative values indicate \code{index1} was better.
}
\description{
Compare the distribution of samples with two different batches.
}
\examples{
index1 <- create_subset(50, 24)
index2 <- batch_names(create_subset(50, 24))
metadata <- expand.grid(height = seq(60, 80, 5), weight = seq(100, 300, 50),
                         sex = c("Male","Female"))
compare_index(metadata, index1, index2)
}
\seealso{
\code{\link[=check_index]{check_index()}}
}
