// Generated by rstantools.  Do not edit by hand.

/*
    expertsurv is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    expertsurv is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with expertsurv.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by %%NAME%% %%VERSION%%
#include <stan/model/model_header.hpp>
namespace model_RP_expert_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 101, column 2 to column 20)",
                                                      " (in 'string', line 102, column 2 to column 17)",
                                                      " (in 'string', line 105, column 2 to column 20)",
                                                      " (in 'string', line 106, column 2 to column 15)",
                                                      " (in 'string', line 107, column 2 to column 34)",
                                                      " (in 'string', line 108, column 2 to column 19)",
                                                      " (in 'string', line 110, column 4 to column 23)",
                                                      " (in 'string', line 109, column 17 to line 111, column 3)",
                                                      " (in 'string', line 109, column 2 to line 111, column 3)",
                                                      " (in 'string', line 113, column 4 to column 58)",
                                                      " (in 'string', line 112, column 28 to line 114, column 3)",
                                                      " (in 'string', line 112, column 2 to line 114, column 3)",
                                                      " (in 'string', line 118, column 2 to column 39)",
                                                      " (in 'string', line 119, column 2 to column 36)",
                                                      " (in 'string', line 121, column 2 to column 35)",
                                                      " (in 'string', line 123, column 5 to line 126, column 44)",
                                                      " (in 'string', line 122, column 28 to line 127, column 3)",
                                                      " (in 'string', line 122, column 2 to line 127, column 3)",
                                                      " (in 'string', line 76, column 2 to column 17)",
                                                      " (in 'string', line 77, column 2 to column 17)",
                                                      " (in 'string', line 78, column 2 to column 17)",
                                                      " (in 'string', line 79, column 18 to column 19)",
                                                      " (in 'string', line 79, column 2 to column 23)",
                                                      " (in 'string', line 80, column 26 to column 27)",
                                                      " (in 'string', line 80, column 2 to column 31)",
                                                      " (in 'string', line 81, column 9 to column 10)",
                                                      " (in 'string', line 81, column 11 to column 12)",
                                                      " (in 'string', line 81, column 2 to column 16)",
                                                      " (in 'string', line 82, column 9 to column 10)",
                                                      " (in 'string', line 82, column 11 to column 14)",
                                                      " (in 'string', line 82, column 2 to column 18)",
                                                      " (in 'string', line 83, column 9 to column 10)",
                                                      " (in 'string', line 83, column 11 to column 14)",
                                                      " (in 'string', line 83, column 2 to column 19)",
                                                      " (in 'string', line 84, column 9 to column 10)",
                                                      " (in 'string', line 84, column 2 to column 20)",
                                                      " (in 'string', line 85, column 19 to column 20)",
                                                      " (in 'string', line 85, column 2 to column 33)",
                                                      " (in 'string', line 86, column 9 to column 12)",
                                                      " (in 'string', line 86, column 2 to column 23)",
                                                      " (in 'string', line 87, column 18 to column 21)",
                                                      " (in 'string', line 87, column 2 to column 35)",
                                                      " (in 'string', line 88, column 2 to column 20)",
                                                      " (in 'string', line 89, column 2 to column 37)",
                                                      " (in 'string', line 90, column 2 to column 12)",
                                                      " (in 'string', line 91, column 2 to column 13)",
                                                      " (in 'string', line 92, column 2 to column 14)",
                                                      " (in 'string', line 93, column 8 to column 21)",
                                                      " (in 'string', line 93, column 2 to column 37)",
                                                      " (in 'string', line 94, column 2 to column 16)",
                                                      " (in 'string', line 95, column 8 to column 22)",
                                                      " (in 'string', line 95, column 25 to column 38)",
                                                      " (in 'string', line 95, column 2 to column 58)",
                                                      " (in 'string', line 96, column 9 to column 37)",
                                                      " (in 'string', line 96, column 2 to column 51)",
                                                      " (in 'string', line 97, column 9 to column 22)",
                                                      " (in 'string', line 97, column 23 to column 26)",
                                                      " (in 'string', line 97, column 2 to column 37)",
                                                      " (in 'string', line 98, column 9 to column 10)",
                                                      " (in 'string', line 98, column 2 to column 15)",
                                                      " (in 'string', line 101, column 9 to column 12)",
                                                      " (in 'string', line 102, column 9 to column 10)",
                                                      " (in 'string', line 105, column 9 to column 10)",
                                                      " (in 'string', line 106, column 9 to column 10)",
                                                      " (in 'string', line 107, column 9 to column 22)",
                                                      " (in 'string', line 10, column 11 to column 26)",
                                                      " (in 'string', line 10, column 4 to column 32)",
                                                      " (in 'string', line 11, column 11 to column 26)",
                                                      " (in 'string', line 11, column 4 to column 38)",
                                                      " (in 'string', line 12, column 11 to column 26)",
                                                      " (in 'string', line 12, column 4 to column 36)",
                                                      " (in 'string', line 13, column 4 to column 15)",
                                                      " (in 'string', line 14, column 4 to column 28)",
                                                      " (in 'string', line 15, column 4 to column 25)",
                                                      " (in 'string', line 16, column 4 to column 63)",
                                                      " (in 'string', line 17, column 4 to column 37)",
                                                      " (in 'string', line 18, column 4 to column 17)",
                                                      " (in 'string', line 3, column 98 to line 19, column 3)",
                                                      " (in 'string', line 25, column 4 to column 13)",
                                                      " (in 'string', line 26, column 4 to column 18)",
                                                      " (in 'string', line 27, column 4 to column 28)",
                                                      " (in 'string', line 28, column 4 to column 30)",
                                                      " (in 'string', line 29, column 4 to column 20)",
                                                      " (in 'string', line 20, column 55 to line 30, column 3)",
                                                      " (in 'string', line 34, column 10 to column 20)",
                                                      " (in 'string', line 34, column 4 to column 32)",
                                                      " (in 'string', line 64, column 12 to column 77)",
                                                      " (in 'string', line 63, column 13 to line 65, column 9)",
                                                      " (in 'string', line 62, column 12 to column 77)",
                                                      " (in 'string', line 61, column 23 to line 63, column 9)",
                                                      " (in 'string', line 61, column 5 to line 65, column 9)",
                                                      " (in 'string', line 60, column 30 to line 66, column 7)",
                                                      " (in 'string', line 60, column 10 to line 66, column 7)",
                                                      " (in 'string', line 58, column 13 to column 83)",
                                                      " (in 'string', line 57, column 13 to line 59, column 9)",
                                                      " (in 'string', line 56, column 12 to column 82)",
                                                      " (in 'string', line 55, column 26 to line 57, column 9)",
                                                      " (in 'string', line 55, column 8 to line 59, column 9)",
                                                      " (in 'string', line 54, column 30 to line 60, column 5)",
                                                      " (in 'string', line 54, column 10 to line 66, column 7)",
                                                      " (in 'string', line 52, column 12 to column 78)",
                                                      " (in 'string', line 51, column 13 to line 53, column 9)",
                                                      " (in 'string', line 50, column 12 to column 78)",
                                                      " (in 'string', line 49, column 26 to line 51, column 9)",
                                                      " (in 'string', line 49, column 8 to line 53, column 9)",
                                                      " (in 'string', line 48, column 30 to line 54, column 5)",
                                                      " (in 'string', line 48, column 10 to line 66, column 7)",
                                                      " (in 'string', line 46, column 10 to column 92)",
                                                      " (in 'string', line 45, column 13 to line 47, column 8)",
                                                      " (in 'string', line 44, column 10 to column 92)",
                                                      " (in 'string', line 43, column 25 to line 45, column 9)",
                                                      " (in 'string', line 43, column 7 to line 47, column 8)",
                                                      " (in 'string', line 42, column 30 to line 48, column 5)",
                                                      " (in 'string', line 42, column 10 to line 66, column 7)",
                                                      " (in 'string', line 40, column 8 to column 75)",
                                                      " (in 'string', line 39, column 11 to line 41, column 7)",
                                                      " (in 'string', line 38, column 8 to column 75)",
                                                      " (in 'string', line 37, column 24 to line 39, column 7)",
                                                      " (in 'string', line 37, column 6 to line 41, column 7)",
                                                      " (in 'string', line 36, column 24 to line 42, column 5)",
                                                      " (in 'string', line 36, column 4 to line 66, column 7)",
                                                      " (in 'string', line 35, column 26 to line 67, column 5)",
                                                      " (in 'string', line 35, column 4 to line 67, column 5)",
                                                      " (in 'string', line 71, column 6 to column 30)",
                                                      " (in 'string', line 70, column 9 to line 72, column 5)",
                                                      " (in 'string', line 69, column 6 to column 29)",
                                                      " (in 'string', line 68, column 22 to line 70, column 5)",
                                                      " (in 'string', line 68, column 4 to line 72, column 5)",
                                                      " (in 'string', line 32, column 61 to line 73, column 3)"};
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__, typename T6__>
stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
stan::value_type_t<T6__>>>
rps_lpdf(const T0__& t_arg__, const T1__& d_arg__, const T2__& gamma_arg__,
         const T3__& B_arg__, const T4__& DB_arg__,
         const T5__& linpred_arg__, const T6__& a0_arg__,
         std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
          stan::value_type_t<T6__>>>;
  const auto& t = to_ref(t_arg__);
  const auto& d = to_ref(d_arg__);
  const auto& gamma = to_ref(gamma_arg__);
  const auto& B = to_ref(B_arg__);
  const auto& DB = to_ref(DB_arg__);
  const auto& linpred = to_ref(linpred_arg__);
  const auto& a0 = to_ref(a0_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 66;
    validate_non_negative_index("eta", "num_elements(t)", num_elements(t));
    Eigen::Matrix<local_scalar_t__, -1, 1> eta;
    eta = Eigen::Matrix<local_scalar_t__, -1, 1>(num_elements(t));
    stan::math::fill(eta, DUMMY_VAR__);
    
    current_statement__ = 68;
    validate_non_negative_index("eta_prime", "num_elements(t)",
                                num_elements(t));
    Eigen::Matrix<local_scalar_t__, -1, 1> eta_prime;
    eta_prime = Eigen::Matrix<local_scalar_t__, -1, 1>(num_elements(t));
    stan::math::fill(eta_prime, DUMMY_VAR__);
    
    current_statement__ = 70;
    validate_non_negative_index("log_lik", "num_elements(t)", num_elements(t));
    Eigen::Matrix<local_scalar_t__, -1, 1> log_lik;
    log_lik = Eigen::Matrix<local_scalar_t__, -1, 1>(num_elements(t));
    stan::math::fill(log_lik, DUMMY_VAR__);
    
    local_scalar_t__ lprob;
    lprob = DUMMY_VAR__;
    
    current_statement__ = 73;
    assign(eta, nil_index_list(), add(multiply(B, gamma), linpred),
      "assigning variable eta");
    current_statement__ = 74;
    assign(eta_prime, nil_index_list(), multiply(DB, gamma),
      "assigning variable eta_prime");
    current_statement__ = 75;
    assign(log_lik, nil_index_list(),
      subtract(
        elt_multiply(d,
          add(add(minus(stan::math::log(t)), stan::math::log(eta_prime)),
            eta)), stan::math::exp(eta)), "assigning variable log_lik");
    current_statement__ = 76;
    lprob = dot_product(log_lik, a0);
    current_statement__ = 77;
    return lprob;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct rps_lpdf_functor__ {
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__, typename T6__>
stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
stan::value_type_t<T6__>>>
operator()(const T0__& t, const T1__& d, const T2__& gamma, const T3__& B,
           const T4__& DB, const T5__& linpred, const T6__& a0,
           std::ostream* pstream__)  const 
{
return rps_lpdf<propto__>(t, d, gamma, B, DB, linpred, a0, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
T2__>
Sind(const T0__& gamma_arg__, const T1__& B_arg__, const T2__& linpred,
     std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          T2__>;
  const auto& gamma = to_ref(gamma_arg__);
  const auto& B = to_ref(B_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ eta;
    eta = DUMMY_VAR__;
    
    local_scalar_t__ Sind_rtn;
    Sind_rtn = DUMMY_VAR__;
    
    current_statement__ = 81;
    eta = (multiply(B, gamma) + linpred);
    current_statement__ = 82;
    Sind_rtn = stan::math::exp(-stan::math::exp(eta));
    current_statement__ = 83;
    return Sind_rtn;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct Sind_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
T2__>
operator()(const T0__& gamma, const T1__& B, const T2__& linpred,
           std::ostream* pstream__)  const 
{
return Sind(gamma, B, linpred, pstream__);
}
};
template <typename T0__, typename T1__>
stan::promote_args_t<T0__,
T1__>
log_density_dist(const std::vector<std::vector<T0__>>& params, const T1__& x,
                 const int& num_expert, const int& pool_type,
                 std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 85;
    validate_non_negative_index("dens", "num_expert", num_expert);
    std::vector<local_scalar_t__> dens;
    dens = std::vector<local_scalar_t__>(num_expert, DUMMY_VAR__);
    
    current_statement__ = 123;
    for (int i = 1; i <= num_expert; ++i) {
      current_statement__ = 121;
      if (logical_eq(params[(i - 1)][(1 - 1)], 1)) {
        current_statement__ = 119;
        if (logical_eq(pool_type, 1)) {
          current_statement__ = 117;
          assign(dens, cons_list(index_uni(i), nil_index_list()),
            (stan::math::exp(
               normal_lpdf<false>(x, params[(i - 1)][(3 - 1)],
                 params[(i - 1)][(4 - 1)])) * params[(i - 1)][(2 - 1)]),
            "assigning variable dens");
        } else {
          current_statement__ = 115;
          assign(dens, cons_list(index_uni(i), nil_index_list()),
            pow(
              stan::math::exp(
                normal_lpdf<false>(x, params[(i - 1)][(3 - 1)],
                  params[(i - 1)][(4 - 1)])), params[(i - 1)][(2 - 1)]),
            "assigning variable dens");
        }
      } else {
        current_statement__ = 114;
        if (logical_eq(params[(i - 1)][(1 - 1)], 2)) {
          current_statement__ = 112;
          if (logical_eq(pool_type, 1)) {
            current_statement__ = 110;
            assign(dens, cons_list(index_uni(i), nil_index_list()),
              (stan::math::exp(
                 student_t_lpdf<false>(x, params[(i - 1)][(5 - 1)],
                   params[(i - 1)][(3 - 1)], params[(i - 1)][(4 - 1)])) *
                params[(i - 1)][(2 - 1)]), "assigning variable dens");
          } else {
            current_statement__ = 108;
            assign(dens, cons_list(index_uni(i), nil_index_list()),
              pow(
                stan::math::exp(
                  student_t_lpdf<false>(x, params[(i - 1)][(5 - 1)],
                    params[(i - 1)][(3 - 1)], params[(i - 1)][(4 - 1)])),
                params[(i - 1)][(2 - 1)]), "assigning variable dens");
          }
        } else {
          current_statement__ = 107;
          if (logical_eq(params[(i - 1)][(1 - 1)], 3)) {
            current_statement__ = 105;
            if (logical_eq(pool_type, 1)) {
              current_statement__ = 103;
              assign(dens, cons_list(index_uni(i), nil_index_list()),
                (stan::math::exp(
                   gamma_lpdf<false>(x, params[(i - 1)][(3 - 1)],
                     params[(i - 1)][(4 - 1)])) * params[(i - 1)][(2 - 1)]),
                "assigning variable dens");
            } else {
              current_statement__ = 101;
              assign(dens, cons_list(index_uni(i), nil_index_list()),
                pow(
                  stan::math::exp(
                    gamma_lpdf<false>(x, params[(i - 1)][(3 - 1)],
                      params[(i - 1)][(4 - 1)])), params[(i - 1)][(2 - 1)]),
                "assigning variable dens");
            }
          } else {
            current_statement__ = 100;
            if (logical_eq(params[(i - 1)][(1 - 1)], 4)) {
              current_statement__ = 98;
              if (logical_eq(pool_type, 1)) {
                current_statement__ = 96;
                assign(dens, cons_list(index_uni(i), nil_index_list()),
                  (stan::math::exp(
                     lognormal_lpdf<false>(x, params[(i - 1)][(3 - 1)],
                       params[(i - 1)][(4 - 1)])) * params[(i - 1)][(2 - 1)]),
                  "assigning variable dens");
              } else {
                current_statement__ = 94;
                assign(dens, cons_list(index_uni(i), nil_index_list()),
                  pow(
                    stan::math::exp(
                      lognormal_lpdf<false>(x, params[(i - 1)][(3 - 1)],
                        params[(i - 1)][(4 - 1)])), params[(i - 1)][(2 - 1)]),
                  "assigning variable dens");
              }
            } else {
              current_statement__ = 93;
              if (logical_eq(params[(i - 1)][(1 - 1)], 5)) {
                current_statement__ = 91;
                if (logical_eq(pool_type, 1)) {
                  current_statement__ = 89;
                  assign(dens, cons_list(index_uni(i), nil_index_list()),
                    (stan::math::exp(
                       beta_lpdf<false>(x, params[(i - 1)][(3 - 1)],
                         params[(i - 1)][(4 - 1)])) *
                      params[(i - 1)][(2 - 1)]), "assigning variable dens");
                } else {
                  current_statement__ = 87;
                  assign(dens, cons_list(index_uni(i), nil_index_list()),
                    pow(
                      stan::math::exp(
                        beta_lpdf<false>(x, params[(i - 1)][(3 - 1)],
                          params[(i - 1)][(4 - 1)])),
                      params[(i - 1)][(2 - 1)]), "assigning variable dens");
                }
              } 
            }
          }
        }
      }}
    current_statement__ = 128;
    if (logical_eq(pool_type, 1)) {
      current_statement__ = 126;
      return stan::math::log(sum(dens));
    } else {
      current_statement__ = 124;
      return stan::math::log(prod(dens));
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct log_density_dist_functor__ {
template <typename T0__, typename T1__>
stan::promote_args_t<T0__,
T1__>
operator()(const std::vector<std::vector<T0__>>& params, const T1__& x,
           const int& num_expert, const int& pool_type,
           std::ostream* pstream__)  const 
{
return log_density_dist(params, x, num_expert, pool_type, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_RP_expert final : public model_base_crtp<model_RP_expert> {
private:
  int n;
  int M;
  int H;
  Eigen::Matrix<double, -1, 1> t;
  Eigen::Matrix<double, -1, 1> d;
  Eigen::Matrix<double, -1, -1> X;
  Eigen::Matrix<double, -1, -1> B;
  Eigen::Matrix<double, -1, -1> DB;
  Eigen::Matrix<double, -1, 1> mu_beta;
  Eigen::Matrix<double, -1, 1> sigma_beta;
  Eigen::Matrix<double, -1, 1> mu_gamma;
  Eigen::Matrix<double, -1, 1> sigma_gamma;
  int n_time_expert;
  int St_indic;
  int id_St;
  int id_trt;
  int id_comp;
  std::vector<int> n_experts;
  int pool_type;
  std::vector<std::vector<std::vector<double>>> param_expert;
  Eigen::Matrix<double, -1, 1> time_expert;
  Eigen::Matrix<double, -1, -1> B_expert;
  Eigen::Matrix<double, -1, 1> a0;
  int gamma_1dim__;
 
public:
  ~model_RP_expert() { }
  
  inline std::string model_name() const final { return "model_RP_expert"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = %%NAME%%3 %%VERSION%%", "stancflags = "};
  }
  
  
  model_RP_expert(stan::io::var_context& context__,
                  unsigned int random_seed__ = 0,
                  std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_RP_expert_namespace::model_RP_expert";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 19;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 19;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 19;
      current_statement__ = 19;
      check_greater_or_equal(function__, "n", n, 1);
      current_statement__ = 20;
      context__.validate_dims("data initialization","M","int",
          context__.to_vec());
      M = std::numeric_limits<int>::min();
      
      current_statement__ = 20;
      M = context__.vals_i("M")[(1 - 1)];
      current_statement__ = 20;
      current_statement__ = 20;
      check_greater_or_equal(function__, "M", M, 0);
      current_statement__ = 21;
      context__.validate_dims("data initialization","H","int",
          context__.to_vec());
      H = std::numeric_limits<int>::min();
      
      current_statement__ = 21;
      H = context__.vals_i("H")[(1 - 1)];
      current_statement__ = 21;
      current_statement__ = 21;
      check_greater_or_equal(function__, "H", H, 1);
      current_statement__ = 22;
      validate_non_negative_index("t", "n", n);
      current_statement__ = 23;
      context__.validate_dims("data initialization","t","double",
          context__.to_vec(n));
      t = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(t, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> t_flat__;
        current_statement__ = 23;
        assign(t_flat__, nil_index_list(), context__.vals_r("t"),
          "assigning variable t_flat__");
        current_statement__ = 23;
        pos__ = 1;
        current_statement__ = 23;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 23;
          assign(t, cons_list(index_uni(sym1__), nil_index_list()),
            t_flat__[(pos__ - 1)], "assigning variable t");
          current_statement__ = 23;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 23;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 23;
        current_statement__ = 23;
        check_greater_or_equal(function__, "t[sym1__]", t[(sym1__ - 1)], 0);}
      current_statement__ = 24;
      validate_non_negative_index("d", "n", n);
      current_statement__ = 25;
      context__.validate_dims("data initialization","d","double",
          context__.to_vec(n));
      d = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(d, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> d_flat__;
        current_statement__ = 25;
        assign(d_flat__, nil_index_list(), context__.vals_r("d"),
          "assigning variable d_flat__");
        current_statement__ = 25;
        pos__ = 1;
        current_statement__ = 25;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 25;
          assign(d, cons_list(index_uni(sym1__), nil_index_list()),
            d_flat__[(pos__ - 1)], "assigning variable d");
          current_statement__ = 25;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 25;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 25;
        current_statement__ = 25;
        check_greater_or_equal(function__, "d[sym1__]", d[(sym1__ - 1)], 0);}
      current_statement__ = 25;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 25;
        current_statement__ = 25;
        check_less_or_equal(function__, "d[sym1__]", d[(sym1__ - 1)], 1);}
      current_statement__ = 26;
      validate_non_negative_index("X", "n", n);
      current_statement__ = 27;
      validate_non_negative_index("X", "H", H);
      current_statement__ = 28;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(n, H));
      X = Eigen::Matrix<double, -1, -1>(n, H);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 28;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 28;
        pos__ = 1;
        current_statement__ = 28;
        for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
          current_statement__ = 28;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 28;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 28;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 29;
      validate_non_negative_index("B", "n", n);
      current_statement__ = 30;
      validate_non_negative_index("B", "M + 2", (M + 2));
      current_statement__ = 31;
      context__.validate_dims("data initialization","B","double",
          context__.to_vec(n, (M + 2)));
      B = Eigen::Matrix<double, -1, -1>(n, (M + 2));
      stan::math::fill(B, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> B_flat__;
        current_statement__ = 31;
        assign(B_flat__, nil_index_list(), context__.vals_r("B"),
          "assigning variable B_flat__");
        current_statement__ = 31;
        pos__ = 1;
        current_statement__ = 31;
        for (int sym1__ = 1; sym1__ <= (M + 2); ++sym1__) {
          current_statement__ = 31;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 31;
            assign(B,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              B_flat__[(pos__ - 1)], "assigning variable B");
            current_statement__ = 31;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 32;
      validate_non_negative_index("DB", "n", n);
      current_statement__ = 33;
      validate_non_negative_index("DB", "M + 2", (M + 2));
      current_statement__ = 34;
      context__.validate_dims("data initialization","DB","double",
          context__.to_vec(n, (M + 2)));
      DB = Eigen::Matrix<double, -1, -1>(n, (M + 2));
      stan::math::fill(DB, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> DB_flat__;
        current_statement__ = 34;
        assign(DB_flat__, nil_index_list(), context__.vals_r("DB"),
          "assigning variable DB_flat__");
        current_statement__ = 34;
        pos__ = 1;
        current_statement__ = 34;
        for (int sym1__ = 1; sym1__ <= (M + 2); ++sym1__) {
          current_statement__ = 34;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 34;
            assign(DB,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              DB_flat__[(pos__ - 1)], "assigning variable DB");
            current_statement__ = 34;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 35;
      validate_non_negative_index("mu_beta", "H", H);
      current_statement__ = 36;
      context__.validate_dims("data initialization","mu_beta","double",
          context__.to_vec(H));
      mu_beta = Eigen::Matrix<double, -1, 1>(H);
      stan::math::fill(mu_beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_beta_flat__;
        current_statement__ = 36;
        assign(mu_beta_flat__, nil_index_list(), context__.vals_r("mu_beta"),
          "assigning variable mu_beta_flat__");
        current_statement__ = 36;
        pos__ = 1;
        current_statement__ = 36;
        for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
          current_statement__ = 36;
          assign(mu_beta, cons_list(index_uni(sym1__), nil_index_list()),
            mu_beta_flat__[(pos__ - 1)], "assigning variable mu_beta");
          current_statement__ = 36;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 37;
      validate_non_negative_index("sigma_beta", "H", H);
      current_statement__ = 38;
      context__.validate_dims("data initialization","sigma_beta","double",
          context__.to_vec(H));
      sigma_beta = Eigen::Matrix<double, -1, 1>(H);
      stan::math::fill(sigma_beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_beta_flat__;
        current_statement__ = 38;
        assign(sigma_beta_flat__, nil_index_list(),
          context__.vals_r("sigma_beta"),
          "assigning variable sigma_beta_flat__");
        current_statement__ = 38;
        pos__ = 1;
        current_statement__ = 38;
        for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
          current_statement__ = 38;
          assign(sigma_beta, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_beta_flat__[(pos__ - 1)], "assigning variable sigma_beta");
          current_statement__ = 38;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 38;
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        current_statement__ = 38;
        current_statement__ = 38;
        check_greater_or_equal(function__, "sigma_beta[sym1__]",
                               sigma_beta[(sym1__ - 1)], 0);}
      current_statement__ = 39;
      validate_non_negative_index("mu_gamma", "M + 2", (M + 2));
      current_statement__ = 40;
      context__.validate_dims("data initialization","mu_gamma","double",
          context__.to_vec((M + 2)));
      mu_gamma = Eigen::Matrix<double, -1, 1>((M + 2));
      stan::math::fill(mu_gamma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_gamma_flat__;
        current_statement__ = 40;
        assign(mu_gamma_flat__, nil_index_list(),
          context__.vals_r("mu_gamma"), "assigning variable mu_gamma_flat__");
        current_statement__ = 40;
        pos__ = 1;
        current_statement__ = 40;
        for (int sym1__ = 1; sym1__ <= (M + 2); ++sym1__) {
          current_statement__ = 40;
          assign(mu_gamma, cons_list(index_uni(sym1__), nil_index_list()),
            mu_gamma_flat__[(pos__ - 1)], "assigning variable mu_gamma");
          current_statement__ = 40;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 41;
      validate_non_negative_index("sigma_gamma", "M + 2", (M + 2));
      current_statement__ = 42;
      context__.validate_dims("data initialization","sigma_gamma","double",
          context__.to_vec((M + 2)));
      sigma_gamma = Eigen::Matrix<double, -1, 1>((M + 2));
      stan::math::fill(sigma_gamma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_gamma_flat__;
        current_statement__ = 42;
        assign(sigma_gamma_flat__, nil_index_list(),
          context__.vals_r("sigma_gamma"),
          "assigning variable sigma_gamma_flat__");
        current_statement__ = 42;
        pos__ = 1;
        current_statement__ = 42;
        for (int sym1__ = 1; sym1__ <= (M + 2); ++sym1__) {
          current_statement__ = 42;
          assign(sigma_gamma, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_gamma_flat__[(pos__ - 1)], "assigning variable sigma_gamma");
          current_statement__ = 42;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 42;
      for (int sym1__ = 1; sym1__ <= (M + 2); ++sym1__) {
        current_statement__ = 42;
        current_statement__ = 42;
        check_greater_or_equal(function__, "sigma_gamma[sym1__]",
                               sigma_gamma[(sym1__ - 1)], 0);}
      current_statement__ = 43;
      context__.validate_dims("data initialization","n_time_expert","int",
          context__.to_vec());
      n_time_expert = std::numeric_limits<int>::min();
      
      current_statement__ = 43;
      n_time_expert = context__.vals_i("n_time_expert")[(1 - 1)];
      current_statement__ = 44;
      context__.validate_dims("data initialization","St_indic","int",
          context__.to_vec());
      St_indic = std::numeric_limits<int>::min();
      
      current_statement__ = 44;
      St_indic = context__.vals_i("St_indic")[(1 - 1)];
      current_statement__ = 44;
      current_statement__ = 44;
      check_greater_or_equal(function__, "St_indic", St_indic, 0);
      current_statement__ = 44;
      current_statement__ = 44;
      check_less_or_equal(function__, "St_indic", St_indic, 1);
      current_statement__ = 45;
      context__.validate_dims("data initialization","id_St","int",
          context__.to_vec());
      id_St = std::numeric_limits<int>::min();
      
      current_statement__ = 45;
      id_St = context__.vals_i("id_St")[(1 - 1)];
      current_statement__ = 46;
      context__.validate_dims("data initialization","id_trt","int",
          context__.to_vec());
      id_trt = std::numeric_limits<int>::min();
      
      current_statement__ = 46;
      id_trt = context__.vals_i("id_trt")[(1 - 1)];
      current_statement__ = 47;
      context__.validate_dims("data initialization","id_comp","int",
          context__.to_vec());
      id_comp = std::numeric_limits<int>::min();
      
      current_statement__ = 47;
      id_comp = context__.vals_i("id_comp")[(1 - 1)];
      current_statement__ = 48;
      validate_non_negative_index("n_experts", "n_time_expert", n_time_expert);
      current_statement__ = 49;
      context__.validate_dims("data initialization","n_experts","int",
          context__.to_vec(n_time_expert));
      n_experts = std::vector<int>(n_time_expert, std::numeric_limits<int>::min());
      
      current_statement__ = 49;
      assign(n_experts, nil_index_list(), context__.vals_i("n_experts"),
        "assigning variable n_experts");
      current_statement__ = 50;
      context__.validate_dims("data initialization","pool_type","int",
          context__.to_vec());
      pool_type = std::numeric_limits<int>::min();
      
      current_statement__ = 50;
      pool_type = context__.vals_i("pool_type")[(1 - 1)];
      current_statement__ = 51;
      validate_non_negative_index("param_expert", "max(n_experts)",
                                  max(n_experts));
      current_statement__ = 52;
      validate_non_negative_index("param_expert", "n_time_expert",
                                  n_time_expert);
      current_statement__ = 53;
      context__.validate_dims("data initialization","param_expert","double",
          context__.to_vec(max(n_experts), 5, n_time_expert));
      param_expert = std::vector<std::vector<std::vector<double>>>(max(
                                                                    n_experts), std::vector<std::vector<double>>(5, std::vector<double>(n_time_expert, std::numeric_limits<double>::quiet_NaN())));
      
      {
        std::vector<local_scalar_t__> param_expert_flat__;
        current_statement__ = 53;
        assign(param_expert_flat__, nil_index_list(),
          context__.vals_r("param_expert"),
          "assigning variable param_expert_flat__");
        current_statement__ = 53;
        pos__ = 1;
        current_statement__ = 53;
        for (int sym1__ = 1; sym1__ <= n_time_expert; ++sym1__) {
          current_statement__ = 53;
          for (int sym2__ = 1; sym2__ <= 5; ++sym2__) {
            current_statement__ = 53;
            for (int sym3__ = 1; sym3__ <= max(n_experts); ++sym3__) {
              current_statement__ = 53;
              assign(param_expert,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                param_expert_flat__[(pos__ - 1)],
                "assigning variable param_expert");
              current_statement__ = 53;
              pos__ = (pos__ + 1);}}}
      }
      current_statement__ = 54;
      validate_non_negative_index("time_expert",
                                  "St_indic ? n_time_expert : 0",
                                  (St_indic ? n_time_expert : 0));
      current_statement__ = 55;
      context__.validate_dims("data initialization","time_expert","double",
          context__.to_vec((St_indic ? n_time_expert : 0)));
      time_expert = Eigen::Matrix<double, -1, 1>((St_indic ? n_time_expert :
                                                    0));
      stan::math::fill(time_expert, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> time_expert_flat__;
        current_statement__ = 55;
        assign(time_expert_flat__, nil_index_list(),
          context__.vals_r("time_expert"),
          "assigning variable time_expert_flat__");
        current_statement__ = 55;
        pos__ = 1;
        current_statement__ = 55;
        for (int sym1__ = 1; sym1__ <= (St_indic ? n_time_expert : 0);
             ++sym1__) {
          current_statement__ = 55;
          assign(time_expert, cons_list(index_uni(sym1__), nil_index_list()),
            time_expert_flat__[(pos__ - 1)], "assigning variable time_expert");
          current_statement__ = 55;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 56;
      validate_non_negative_index("B_expert", "n_time_expert", n_time_expert);
      current_statement__ = 57;
      validate_non_negative_index("B_expert", "M + 2", (M + 2));
      current_statement__ = 58;
      context__.validate_dims("data initialization","B_expert","double",
          context__.to_vec(n_time_expert, (M + 2)));
      B_expert = Eigen::Matrix<double, -1, -1>(n_time_expert, (M + 2));
      stan::math::fill(B_expert, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> B_expert_flat__;
        current_statement__ = 58;
        assign(B_expert_flat__, nil_index_list(),
          context__.vals_r("B_expert"), "assigning variable B_expert_flat__");
        current_statement__ = 58;
        pos__ = 1;
        current_statement__ = 58;
        for (int sym1__ = 1; sym1__ <= (M + 2); ++sym1__) {
          current_statement__ = 58;
          for (int sym2__ = 1; sym2__ <= n_time_expert; ++sym2__) {
            current_statement__ = 58;
            assign(B_expert,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              B_expert_flat__[(pos__ - 1)], "assigning variable B_expert");
            current_statement__ = 58;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 59;
      validate_non_negative_index("a0", "n", n);
      current_statement__ = 60;
      context__.validate_dims("data initialization","a0","double",
          context__.to_vec(n));
      a0 = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(a0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> a0_flat__;
        current_statement__ = 60;
        assign(a0_flat__, nil_index_list(), context__.vals_r("a0"),
          "assigning variable a0_flat__");
        current_statement__ = 60;
        pos__ = 1;
        current_statement__ = 60;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 60;
          assign(a0, cons_list(index_uni(sym1__), nil_index_list()),
            a0_flat__[(pos__ - 1)], "assigning variable a0");
          current_statement__ = 60;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 61;
      gamma_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 61;
      gamma_1dim__ = (M + 2);
      current_statement__ = 61;
      validate_non_negative_index("gamma", "M + 2", gamma_1dim__);
      current_statement__ = 62;
      validate_non_negative_index("beta", "H", H);
      current_statement__ = 63;
      validate_non_negative_index("linpred", "n", n);
      current_statement__ = 64;
      validate_non_negative_index("mu", "n", n);
      current_statement__ = 65;
      validate_non_negative_index("St_expert", "n_time_expert", n_time_expert);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += gamma_1dim__;
      num_params_r__ += H;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_RP_expert_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> gamma;
      gamma = Eigen::Matrix<local_scalar_t__, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, DUMMY_VAR__);
      
      current_statement__ = 1;
      gamma = in__.vector(gamma_1dim__);
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(H);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 2;
      beta = in__.vector(H);
      Eigen::Matrix<local_scalar_t__, -1, 1> linpred;
      linpred = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(linpred, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> mu;
      mu = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(mu, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> St_expert;
      St_expert = Eigen::Matrix<local_scalar_t__, -1, 1>(n_time_expert);
      stan::math::fill(St_expert, DUMMY_VAR__);
      
      current_statement__ = 6;
      assign(linpred, nil_index_list(), multiply(X, beta),
        "assigning variable linpred");
      current_statement__ = 9;
      for (int i = 1; i <= n; ++i) {
        current_statement__ = 7;
        assign(mu, cons_list(index_uni(i), nil_index_list()),
          linpred[(i - 1)], "assigning variable mu");}
      current_statement__ = 12;
      for (int i = 1; i <= n_time_expert; ++i) {
        current_statement__ = 10;
        assign(St_expert, cons_list(index_uni(i), nil_index_list()),
          Sind(gamma, row(B_expert, i), mu[(id_St - 1)], pstream__),
          "assigning variable St_expert");}
      {
        current_statement__ = 13;
        lp_accum__.add(normal_lpdf<propto__>(gamma, mu_gamma, sigma_gamma));
        current_statement__ = 14;
        lp_accum__.add(normal_lpdf<propto__>(beta, mu_beta, sigma_beta));
        current_statement__ = 15;
        lp_accum__.add(
          rps_lpdf<propto__>(t, d, gamma, B, DB, multiply(X, beta),
            a0, pstream__));
        current_statement__ = 18;
        for (int i = 1; i <= n_time_expert; ++i) {
          current_statement__ = 16;
          lp_accum__.add(
            log_density_dist(
              rvalue(param_expert,
                cons_list(index_omni(),
                  cons_list(index_omni(),
                    cons_list(index_uni(i), nil_index_list()))),
                "param_expert"), St_expert[(i - 1)], n_experts[(i - 1)],
              pool_type, pstream__));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_RP_expert_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> gamma;
      gamma = Eigen::Matrix<double, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      gamma = in__.vector(gamma_1dim__);
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(H);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      beta = in__.vector(H);
      Eigen::Matrix<double, -1, 1> linpred;
      linpred = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(linpred, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> mu;
      mu = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> St_expert;
      St_expert = Eigen::Matrix<double, -1, 1>(n_time_expert);
      stan::math::fill(St_expert, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        vars__.emplace_back(gamma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 6;
      assign(linpred, nil_index_list(), multiply(X, beta),
        "assigning variable linpred");
      current_statement__ = 9;
      for (int i = 1; i <= n; ++i) {
        current_statement__ = 7;
        assign(mu, cons_list(index_uni(i), nil_index_list()),
          linpred[(i - 1)], "assigning variable mu");}
      current_statement__ = 12;
      for (int i = 1; i <= n_time_expert; ++i) {
        current_statement__ = 10;
        assign(St_expert, cons_list(index_uni(i), nil_index_list()),
          Sind(gamma, row(B_expert, i), mu[(id_St - 1)], pstream__),
          "assigning variable St_expert");}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          vars__.emplace_back(linpred[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          vars__.emplace_back(mu[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= n_time_expert; ++sym1__) {
          vars__.emplace_back(St_expert[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> gamma;
      gamma = Eigen::Matrix<double, -1, 1>(gamma_1dim__);
      stan::math::fill(gamma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma_flat__;
        current_statement__ = 1;
        assign(gamma_flat__, nil_index_list(), context__.vals_r("gamma"),
          "assigning variable gamma_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
          current_statement__ = 1;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            gamma_flat__[(pos__ - 1)], "assigning variable gamma");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(H);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 2;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
          current_statement__ = 2;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        vars__.emplace_back(gamma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("gamma");
    names__.emplace_back("beta");
    names__.emplace_back("linpred");
    names__.emplace_back("mu");
    names__.emplace_back("St_expert");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(gamma_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(H)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(n_time_expert)
                                             });
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "linpred" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_time_expert; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "St_expert" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "linpred" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= n_time_expert; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "St_expert" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" << gamma_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << H << "},\"block\":\"parameters\"},{\"name\":\"linpred\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"St_expert\",\"type\":{\"name\":\"vector\",\"length\":" << n_time_expert << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" << gamma_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << H << "},\"block\":\"parameters\"},{\"name\":\"linpred\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << n << "},\"block\":\"transformed_parameters\"},{\"name\":\"St_expert\",\"type\":{\"name\":\"vector\",\"length\":" << n_time_expert << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_RP_expert_namespace::model_RP_expert;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_RP_expert_namespace::profiles__;
}
#endif
#endif
