% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_arrow}
\alias{get_arrow}
\title{Prepare arrow supporting the explanation of graphical elements}
\usage{
get_arrow(model, x_range, rl_index, mtbs = "verified")
}
\arguments{
\item{model}{An \sQuote{\code{expirest_osle}} or an
\sQuote{\code{expirest_Wisle}} object, i.e. a list returned
by the \code{\link{expirest_osle}()} or by the
\code{\link{expirest_wisle}()} function.}

\item{x_range}{A numeric vector of the form \code{c(min, max)} that
specifies the range of the time variable to be plotted.}

\item{rl_index}{A positive integer that specifies which of the release limit
values that have been handed over to \code{\link{expirest_wisle}()} should
be displayed. The default is \code{NULL}.}

\item{mtbs}{A character string that specifies the \dQuote{model to be shown},
i.e. either \code{verified}, which is the default, or one of \code{cics},
\code{dics}, \code{dids} or \code{dids.pmse}. The \code{verified} model
is the model that was identified through the poolability check. It is
thus also one of the possible optional models. The \code{dids} model
represents the case where a separate model is fitted to the data of each
individual batch while the \code{dids.pmse} model is the interaction
model which includes the \eqn{batch} variable as main effect and in the
interaction term with the \eqn{time} variable (\eqn{batch \times time}),
i.e. a model where the mean square error is pooled across batches.}
}
\value{
A data frame with the columns \sQuote{Time.1}, \sQuote{Time.2},
\sQuote{Response.1}, \sQuote{Response.2}, Item, Colour, Line.Type,
Arrow.Type, Size, Curvature, Angle and Length is returned, where the column
names \sQuote{Time.1}, \sQuote{Time.2}, \sQuote{Response.1} and
\sQuote{Response.2} are placeholders for the corresponding variable names.
The data frame has a single row representing the arrow that is put on the
graphical illustration.
}
\description{
The function \code{get_arrows()} prepares a data frame for putting an
arrow on a plot prepared by the \code{ggplot()} function from the
\sQuote{\code{ggplot2}} package.
}
\details{
The function \code{get_arrows()} expects various pieces
of information that characterises an \sQuote{\code{expirest_osle}} or an
\sQuote{\code{expirest_wisle}} model. Based on the information provided,
the function prepares a data frame that that is used by the function
\code{\link{plot_expirest_wisle}(})) to put an arrow on the graph that
is prepared by this function.
}
\seealso{
\code{\link{plot_expirest_osle}}, \code{\link{plot_expirest_wisle}},
\code{\link[ggplot2]{ggplot}}, \code{\link[ggplot2]{geom_text}}.
}
\keyword{internal}
