% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_text_annotation}
\alias{get_text_annotation}
\title{Prepare text annotation}
\usage{
get_text_annotation(
  model,
  rvu,
  x_range,
  y_range,
  rl_index = NULL,
  plot_option = "full",
  mtbs = "verified"
)
}
\arguments{
\item{model}{An \sQuote{\code{expirest_osle}} or an
\sQuote{\code{expirest_Wisle}} object, i.e. a list returned
by the \code{\link{expirest_osle}()} or by the
\code{\link{expirest_wisle}()} function.}

\item{rvu}{A character string that specifies the unit associated with the
response variable.}

\item{x_range}{A numeric vector of the form \code{c(min, max)} that
specifies the range of the time variable to be plotted.}

\item{y_range}{A numeric vector of the form \code{c(min, max)} that
specifies the range of the response variable to be plotted.}

\item{rl_index}{A positive integer that specifies which of the release limit
values that have been handed over to \code{\link{expirest_wisle}()} should
be displayed. The default is \code{NULL}.}

\item{plot_option}{A character string of either \code{"full"}, \code{"lean"},
\code{"lean1"}, \code{"lean2"}, \code{"basic1"} and \code{"basic2"},
that specifies if additional information should be shown in the plot
(option \code{"full"}) or only basic information (options \code{"lean"}
and \code{"basic"}). Full means the data points, the fitted regression
line with the confidence or prediction interval, the specification
limit(s) and the estimated shelf life. For \sQuote{expirest_osle} objects,
only the options \code{"full"} and \code{"lean"} are relevant. The default
is \code{"full"}.}

\item{mtbs}{A character string that specifies the \dQuote{model to be shown},
i.e. either \code{verified}, which is the default, or one of \code{cics},
\code{dics}, \code{dids} or \code{dids.pmse}. The \code{verified} model
is the model that was identified through the poolability check. It is
thus also one of the possible optional models. The \code{dids} model
represents the case where a separate model is fitted to the data of each
individual batch while the \code{dids.pmse} model is the interaction
model which includes the \eqn{batch} variable as main effect and in the
interaction term with the \eqn{time} variable (\eqn{batch \times time}),
i.e. a model where the mean square error is pooled across batches.}
}
\value{
A data frame with the columns \sQuote{Time}, \sQuote{Response},
Label and Colour is returned, where the column names \sQuote{Time} and
\sQuote{Response} are placeholders for the corresponding variable names.
If \code{model} is an \sQuote{expirest_osle} object, the data frame has up
to three rows representing the relevant specification limit(s) (row 1 or
rows 1 and 2) and the POI obtained from ordinary shelf life estimation (row
2 or 3). If \code{model} is an \sQuote{expirest_wisle} object, the data
frame has up to seven rows representing the relevant specification limit(s),
the worst case scenario limit (row 2 or 3), the intercept (row 3 or 4), the
POI of the worst case scenario model (row 4 or 5), the POI obtained from
ordinary shelf life  estimation (row 5 or 6) and the release limit (row 6
or 7).
}
\description{
The function \code{get_text_annotation()} prepares a data frame for putting
text on a plot prepared by the \code{ggplot()} function from the
\sQuote{\code{ggplot2}} package.
}
\details{
The function \code{get_text_annotation()} expects various pieces
of information characterising an \sQuote{\code{expirest_osle}} or an
\sQuote{\code{expirest_wisle}} model. With this information, the function
prepares a data frame that that is used by the functions
\code{\link{plot_expirest_osle}()} or \code{\link{plot_expirest_wisle}(}))
to put text annotations on the graph that is prepared by these functions.
}
\seealso{
\code{\link{plot_expirest_osle}}, \code{\link{plot_expirest_wisle}},
\code{\link{print_val}}, \code{\link[ggplot2]{ggplot}},
\code{\link[ggplot2]{geom_text}}.
}
\keyword{internal}
