% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eppMatrix.R
\docType{class}
\name{eppMatrix-class}
\alias{eppMatrix-class}
\alias{eppMatrix}
\title{Convert a \code{data.frame} to an eppMatrix object.}
\usage{
eppMatrix(data, pairs = ~male + female)
}
\arguments{
\item{data}{a \code{data.frame}}

\item{pairs}{a formula indicating the extra-pair male and the extra-pair female in that order.}
}
\value{
An object of class \code{eppMatrix} with two slots.
}
\description{
Converts a \code{data.frame} to a eppMatrix object using a
\code{~male+female} formula.
}
\section{Slots}{

\describe{
\item{\code{male}}{extra-pair male   ID-s as character vectors}

\item{\code{female}}{extra-pair female ID-s as character vectors}
}}

\examples{

eppPairs = data.frame(male = c("m1", "m2", "m1"), female=c("f3", "f1", "f2") )
e = eppMatrix(eppPairs,  pairs = ~ male + female)
class(e)
showClass("eppMatrix")

data(bluetit_breeding)
data(bluetit_epp)
b = bluetit_breeding[bluetit_breeding$year_ == 2010, ]
eppPairs = bluetit_epp[bluetit_epp$year_ == 2010, ]

breedingDat  = SpatialPointsBreeding(b, id = 'id', coords = ~ x + y, breeding = ~ male + female)
eppDat = eppMatrix(eppPairs, pairs = ~ male + female)

plot(breedingDat, eppDat)

}
\seealso{
\code{\link[expp]{epp}}
}
